<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Event;
use Str;
use Cache;

class EventController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        $page_data = [
            'title' => 'Events',
            'slug' => 'All Events'
        ];
        $page = request()->get('page', 1);
        $limit = request()->get('limit', 10);
        $events = Cache::remember('categories' . $page, 20, function () use ($limit) {
            return Event::select('id','name','image','description')->orderBy('id', 'DESC')->paginate($limit);
        });

        return view('admin.pages.events.index', get_defined_vars())
            ->with('i', ($page - 1) * 5);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $page_data = [
            'title' => 'Events',
            'slug' => 'Add New Event'
        ];
        return view('admin.pages.events.create',get_defined_vars());
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        // dd($request->all());
        $event = new Event;

    	if($request->hasFile('image')){
    		$file = $request->file('image');
    		$image = uniqid().'.'.$file->guessExtension();
    		$image_path = $file->move(public_path().'/admin-assets/images/events/',$image);
        
    		$event->name = $request->name;
    		$event->slug = Str::slug($request->name);
    		$event->description = $request->description;
            $event->image = $image;
            $event->is_exclusive = $request->is_exclusive;
    		$event->status = 0;

    		if( $event->save() ){
    			return redirect()->route('events.index')->withSuccess('Event Added Successfully');
    		}
    		else{
    			return back()->withError('Something went wrong!');
    		}
    	}
    	else{
    		return back()->with('error','Please Upload Store Media!');
    	}
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $page_data = [
            'title' => 'Events',
            'slug' => 'Edit Event'
        ];
        $event = Event::find($id);
        return view('admin.pages.events.edit',get_defined_vars());
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $event =  Event::find($id);

    	if($request->hasFile('image')){
    		$file = $request->file('image');
    		$image = uniqid().'.'.$file->guessExtension();
    		$image_path = $file->move(public_path().'/assets/images/events/',$image);
            $event->image = $image;

        }
    		$event->name = $request->name;
    		$event->slug = Str::slug($request->name);
    		$event->description = $request->description;
            $event->is_exclusive = $request->is_exclusive;

    		if( $event->save() ){
    			return redirect()->route('events.index')->withSuccess('Event Updated Successfully');
    		}
    		else{
    			return back()->withError('Something went wrong!');
    		}
    	
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $event = Event::find($id);
        if($event->delete())
        {
           
        	return redirect()->route('events.index')->withSuccess('Event deleted Successfully');
    		}
    		else{
    			return back()->withError('Something went wrong!');
    		}
    }
}