@extends('admin.layouts.app')
@section('custom-styles')
    <!-- Bootstrap Select Css -->
    <link href="{{ asset('admin-assets/css/bootstrap-select.css') }}" rel="stylesheet" />
@endsection
@section('content')
    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card">
                <div class="header">
                    <h2><strong>Add </strong> new Coupon</h2>

                </div>
                <div class="mt-2">
                    @include('admin.layouts.partials.messages')
                </div>
                <div class="body">
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <strong>Whoops!</strong> There were some problems with your input.<br><br>
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form method="POST" action="{{ route('coupons.update', $coupon->id) }}" autocomplete="off"
                        enctype="multipart/form-data">
                        @method('patch')
                        @csrf
                        <label for="name">Name</label>
                        <div class="form-group">
                            <input type="text" id="name" class="form-control" placeholder="Enter Coupon Title"
                                name="title" value="{{ $coupon->title }}" required>
                            @if ($errors->has('title'))
                                <span class="text-danger">{{ $errors->first('title') }}</span>
                            @endif
                        </div>
                        <label class="form-label">Stores</label>
                        <div class="form-group">
                            <select class="form-control show-tick" name="store_id">
                                <option value="{{ $coupon->store_id }}">{{ $coupon->store->name }}</option>
                                <option value="">--select Store--</option>
                                @foreach ($stores as $key => $store)
                                    <option value="{{ $key }}">{{ $store }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Type</label>
                                <div class="form-group">
                                    <select class="form-control show-tick" name="type">
                                        <option value="{{ $coupon->type }}">{{ $coupon->type }}</option>
                                        <option value="">--select Type--</option>
                                        <option value="code">Code</option>
                                        <option value="deal">Deal</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-6">
                                <label for="total_use">Total Use</label>
                               <div class="form-group">
                                <input type="text" class="form-control" id="total_use" name="total_use"
                                placeholder="Enter Total Use" value="{{ $coupon->total_use }}">
                               </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="url">Url</label>
                                <div class="form-group">
                                    <input type="text" id="url" class="form-control" placeholder="Enter Coupon Url"
                                        name="url" value="{{ $coupon->url }}">
                                    @if ($errors->has('url'))
                                        <span class="text-danger">{{ $errors->first('url') }}</span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Code</label>
                                <div class="form-group">
                                <input type="text" class="form-control" name="code" value="{{ $coupon->code }}">

                                </div>
                            </div>

                        </div>
                        <label for="description">Description</label>
                        <div class="form-group">
                            <textarea id="description" class="form-control" name="description" placeholder="Entere Coupon Description">{{ $coupon->description }}</textarea>
                            @if ($errors->has('description'))
                                <span class="text-danger">{{ $errors->first('description') }}</span>
                            @endif
                        </div>
                        <div class="col-6">
                            <label class="form-label">Start Date</label>
                            <div class="form-group">
                                <input type="date" class="form-control " name="start_date"
                                value="{{ $coupon->start_date }}" />
                            </div>
                        </div>
                        <div class="col-6">
                            <label class="form-label">End Date</label>
                            <div class="form-group">
                                <input type="date" class="form-control " name="end_date"
                                value="{{ $coupon->end_date }}" />
                            </div>
                        </div>
                        <div class="col-6">
                            <label class="form-label">Status</label>
                            <div class="form-group">
                                <select name="status" class="form-control">
                                    <option value="{{ $coupon->status }}">
                                        @if ($coupon->status == 0)
                                            Active
                                        @else
                                            De-Active
                                        @endif
                                    </option>
                                    <option value="">--Select Status--</option>
                                    <option value="0">Active</option>
                                    <option value="1">De-Active</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="checkbox">
                                <input id="is_exclusive" type="checkbox" name="is_exclusive" value="yes">
                                <label for="is_exclusive">Is Exclusive?</label>
    
                            </div>
                        </div>

                        <button type="submit" class="btn btn-raised btn-primary  waves-effect">Save</button>
                        <a href="{{ route('coupons.index') }}" class="btn btn-default">Back</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
