@extends('admin.layouts.app')

@section('content')
    <div class="row clearfix">
        <div class="col-lg-12">
            <div class="card">
                <div class="header">
                    <h2><strong>All</strong> Categories </h2>
                    <ul class="header-dropdown">
                        <li class="dropdown">
                            <a href="{{ route('subcategories.create') }}" class="btn btn-primary btn-sm float-right">Add
                                Sub Category</a>
                        </li>
                    </ul>
                </div>
                <div class="mt-2">
                    @include('admin.layouts.partials.messages')
                </div>
                <div class="body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover js-basic-example dataTable">
                            <thead>
                                <tr>
                                    <th>Logo</th>
                                    <th>Image</th>
                                    <th>Category</th>
                                    <th>Name</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tfoot>
                                <tr>
                                    <th>Logo</th>
                                    <th>Image</th>
                                    <th>Category</th>
                                    <th>Name</th>
                                    <th>Actions</th>
                                </tr>
                            </tfoot>
                            <tbody>
                                @foreach ($subcategories as $key => $subcategory)
                                    <tr>
                                        <td><img src="{{asset('admin-assets/images/categories')}}/{{$subcategory->logo_image}}" alt="" width="40"></td>
                                        <td><img src="{{asset('admin-assets/images/categories')}}/{{$subcategory->feature_image}}" alt="" width="40"></td>
                                        <td>{{ $subcategory->category->name ?? '' }}</td>
                                        <td>{{ $subcategory->name }}</td>
                                        <td>
                                            <a class="btn btn-primary btn-sm" href="{{ route('subcategories.edit', $subcategory->id) }}">Edit</a>
                                        
                                            {!! Form::open(['method' => 'DELETE','route' => ['subcategories.destroy', $subcategory->id],'style'=>'display:inline']) !!}
                                            {!! Form::submit('Delete', ['class' => 'btn btn-danger btn-sm']) !!}
                                            {!! Form::close() !!}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        <div class="d-flex">
                            {!! $subcategories->links('pagination::bootstrap-4') !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('custom-scripts')
   
@endsection