<footer class="bg-white border-t-4 border-black mt-16 font-serif text-black max-w-7xl mx-auto px-8 py-12">

  <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12">

    <!-- Column 1: Logo + About + Social -->
    <div class="space-y-6">
      <div class="flex items-center gap-3 border-b-4 border-black pb-4">
        <img src="@if($settings){{ asset('admin-assets/images/logos/'.$settings->footer_logo) }}@endif" alt="Logo" class="h-12 object-contain" />
      </div>
      <p class="text-sm leading-relaxed tracking-tight text-justify">
        Your Central Hub for News, Trends & Smart Shopping
      </p>

      <div class="flex space-x-4 text-black">
        <!-- Social Icons -->
        @php
        $social_links = \App\Models\SocialMedia::get();
        @endphp
        @foreach($social_links as $social)
        <a href="{{$social->url}}" target="_blank" rel="noopener noreferrer" 
           aria-label="" 
           class="text-gray-600 hover:text-gray-900 transition-colors">
              <i class="{{$social->icon}} h-5 w-5"></i>
        </a>
        @endforeach
      </div>
    </div>

    <!-- Column 2: Categories -->
    <div>
      <h4 class="uppercase font-black tracking-tight border-b-4 border-black pb-2 mb-6 text-lg">Categories</h4>
      <ul class="space-y-4 text-sm leading-relaxed text-justify">
        @php
          $categories = \App\Models\Category::select('id', 'slug', 'name')->limit(5)->get();
        @endphp
        @foreach ($categories as $category)
          <li><a href="{{route('blogs.category',$category->slug)}}" class="hover:underline">{{ $category->name }}</a></li>
        @endforeach
      </ul>
    </div>

    <!-- Column 3: Information -->
    <div>
      <h4 class="uppercase font-black tracking-tight border-b-4 border-black pb-2 mb-6 text-lg">Information</h4>
      <ul class="space-y-4 text-sm leading-relaxed text-justify">
        @php
          $pages = \App\Models\Page::all();
        @endphp
        @foreach ($pages as $page)
          <li><a href="{{ route('page', $page->slug) }}" class="hover:underline">{{ $page->title }}</a></li>
        @endforeach
      </ul>
    </div>

    <!-- Column 4: Newsletter -->
    <div>
      <h4 class="uppercase font-black tracking-tight border-b-4 border-black pb-2 mb-6 text-lg">Newsletter</h4>
      <p class="text-sm text-justify mb-6">
        Subscribe to get the latest updates and offers.
      </p>
      <form class="flex flex-col w-full max-w-md mx-auto gap-3">
  <!-- Input -->
  <input type="email" placeholder="Your email"
         class="w-full rounded border-2 border-black px-4 py-2 text-sm font-serif focus:outline-none focus:ring-2 focus:ring-black" />

  <!-- Button -->
  <button type="submit"
          class="w-full rounded border-2 border-black bg-black text-white px-6 py-2 font-semibold uppercase tracking-wide hover:bg-gray-900 transition-colors">
    Subscribe
  </button>
</form>

    </div>

  </div>

  <!-- Bottom bar -->
  <div class="border-t-4 border-black mt-12 pt-6 text-center text-xs font-serif tracking-widest uppercase text-black">
    <p>
      &copy; <script>document.write(new Date().getFullYear())</script> 
      @if ($settings) {{ $settings->site_title }} @endif — All rights reserved.
    </p>
    <p class="mt-1">Made with ❤️</p>
  </div>

</footer>
