<header class="bg-white border-b border-gray-900 font-serif max-w-7xl mx-auto px-6 py-6 sticky top-0 z-50 shadow-sm">
  <div class="flex items-center justify-between">

    <!-- Logo -->
    <a href="{{ route('index') }}" class="flex items-center space-x-3" aria-label="Homepage">
      <img src="@if($settings){{ asset('admin-assets/images/logos/'.$settings->main_logo) }}@endif" alt="Logo" class="h-12  rounded-sm" />
      
    </a>

    <!-- Navigation -->
   <!-- Navigation -->
<nav role="menubar" aria-label="Primary navigation" class="hidden md:flex space-x-4">
  <a href="{{ route('index') }}"
     class="relative font-bold text-gray-900 hover:text-gray-700 uppercase tracking-wider focus:outline-none focus:ring-2 focus:ring-gray-900 focus:ring-offset-2 px-2"
     aria-current="{{ request()->routeIs('index') ? 'page' : '' }}" style="font-size: 0.875rem;">
    Home
    <span class="absolute bottom-0 left-0 w-full h-0.5 bg-gray-900"></span>
  </a>

  @foreach(\App\Models\Category::select('id','slug','name')->limit(5)->get() as $category)
  <a href="{{ route('blogs.category', $category->slug) }}"
     class="relative font-semibold text-gray-900 hover:text-gray-700 uppercase tracking-wide focus:outline-none focus:ring-2 focus:ring-gray-900 focus:ring-offset-2 px-2"
     role="menuitem" tabindex="0" title="{{ $category->name }}" style="font-size: 0.875rem;">
    {{ $category->name }}
    <span class="absolute bottom-0 left-0 w-0 group-hover:w-full h-0.5 bg-gray-900 transition-all duration-300"></span>
  </a>
  @endforeach
</nav>


    <!-- Social Links -->
    <div class="hidden md:flex space-x-6 text-gray-900" role="list" aria-label="Social media links">
      @foreach(\App\Models\SocialMedia::get() as $link)
      <a href="{{ $link->url }}" class="hover:text-gray-700 transition-colors duration-300 focus:outline-none focus:ring-2 focus:ring-gray-900 rounded" aria-label="{{ $link->title }}" role="listitem" target="_blank" rel="noopener noreferrer">
        <i class="fa {{ $link->title }} text-lg"></i>
      </a>
      @endforeach
    </div>

    <!-- Mobile Hamburger -->
    <button id="mobile-menu-btn" class="md:hidden text-gray-900 focus:outline-none focus:ring-2 focus:ring-gray-900 rounded" aria-label="Open menu" aria-haspopup="true" aria-controls="mobile-menu">
      <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24" aria-hidden="true">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
      </svg>
    </button>
  </div>

  <!-- Mobile Menu -->
  <div id="mobile-menu" class="fixed bottom-0 left-0 w-full bg-white shadow-lg transform translate-y-full transition-transform duration-300 z-50 rounded-t-lg max-h-[70vh] overflow-auto" role="dialog" aria-modal="true" aria-labelledby="mobile-menu-label" tabindex="-1">
    <div class="flex justify-between items-center px-6 py-4 border-b border-gray-900">
      <h2 id="mobile-menu-label" class="font-semibold text-lg text-gray-900 uppercase">Menu</h2>
      <button id="mobile-menu-close" class="p-2 rounded hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-gray-900" aria-label="Close menu">
        <svg class="w-6 h-6 text-gray-900" fill="none" stroke="currentColor" viewBox="0 0 24 24" aria-hidden="true">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
        </svg>
      </button>
    </div>

    <nav class="p-6 space-y-6 font-semibold text-gray-900 uppercase tracking-wide" role="menu" aria-label="Mobile primary navigation">
      <a href="{{ route('index') }}" class="block hover:text-gray-700 truncate" role="menuitem" title="Home">Home</a>
      @foreach(\App\Models\Category::select('id','slug','name')->get() as $category)
      <a href="{{ route('blogs.category', $category->slug) }}" class="block hover:text-gray-700 truncate" role="menuitem" title="{{ $category->name }}">
        {{ $category->name }}
      </a>
      @endforeach

      <div class="flex space-x-8 mt-6 text-gray-900" role="list" aria-label="Mobile social links">
        @foreach(\App\Models\SocialMedia::get() as $link)
        <a href="{{ $link->url }}" class="hover:text-gray-700 transition-colors duration-300" aria-label="{{ $link->title }}" role="listitem" target="_blank" rel="noopener noreferrer">
          <i class="fa {{ $link->title }} text-lg"></i>
        </a>
        @endforeach
      </div>
    </nav>
  </div>

  <script>
    const mobileBtn = document.getElementById('mobile-menu-btn');
    const mobileMenu = document.getElementById('mobile-menu');
    const mobileClose = document.getElementById('mobile-menu-close');

    mobileBtn.addEventListener('click', () => {
      mobileMenu.classList.remove('translate-y-full');
      mobileMenu.focus();
    });

    mobileClose.addEventListener('click', () => {
      mobileMenu.classList.add('translate-y-full');
    });

    document.addEventListener('keydown', (e) => {
      if (e.key === 'Escape') {
        mobileMenu.classList.add('translate-y-full');
      }
    });
  </script>
</header>
