@extends('user.layouts.app')
@section('meta-content')
 @php
    $settings = \App\Models\GeneralSetting::find(1);
    @endphp
<title>@if($settings){{$settings->site_title}}@endif</title>
<meta name="description" content="@if($settings){{$settings->meta_description}}@endif">
<meta name="title" content="@if($settings){{$settings->meta_title}}@endif">
@endsection
@section('content')
 <nav class="bg-white py-3 border-b-4 border-black" aria-label="Breadcrumb">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <ol class="flex flex-wrap items-center gap-2 text-sm text-black font-serif uppercase tracking-tight">

      <!-- Home -->
      <li class="flex items-center gap-1 border-r-2 border-black pr-3">
        <a href="{{ route('index') }}" class="hover:text-gray-600 flex items-center gap-1">
          <svg class="h-4 w-4 shrink-0" fill="currentColor" viewBox="0 0 20 20" class="text-black">
            <path d="M10.707 1.707a1 1 0 00-1.414 0L2 9h3v6a1 1 0 001 1h8a1 1 0 001-1V9h3l-7.293-7.293z" />
          </svg>
          <span class="whitespace-nowrap">Home</span>
        </a>
      </li>

      <!-- Divider -->
      <li class="text-black">
        <svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
          <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L11.586 9 7.293 4.707a1 1 0 111.414-1.414l5 5a1 1 0 010 1.414l-5 5a1 1 0 01-1.414 0z" clip-rule="evenodd" />
        </svg>
      </li>

      <!-- Current Category -->
      <li class="flex items-center">
        <span class="text-black font-serif uppercase tracking-tight">{{ $category->name }}</span>
      </li>
    </ol>
  </div>
</nav>

<section class="py-16 bg-white font-serif text-black">
  @foreach ($subcategories as $subcategory)
    <div class="max-w-7xl mx-auto px-6 mb-16">
      <h2 class="text-3xl uppercase tracking-tight font-black border-t-8 border-black pt-3 mb-8 text-justify">
        {{ $subcategory->name }}
      </h2>

      <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8">
        @php
          $categoryblogs = \App\Models\Blog::with(['category:id,name', 'sub_category:id,name'])
              ->inRandomOrder()
              ->where('blogs.sub_category_id', $subcategory->id)
              ->get();
        @endphp
        @foreach ($categoryblogs as $row)
          <article class="border-4 border-black p-4 hover:border-gray-700 transition-colors duration-300">
            <img src="{{ asset('admin-assets/images/blogs') }}/{{ $row->feature_image }}" alt="{{ $row->title }}" class="w-full h-40 object-cover mb-3" />
            <span class="text-xs uppercase tracking-tight font-semibold block mb-1">{{ $row->sub_category->name }}</span>
            <h4 class="text-lg font-bold uppercase tracking-tight text-justify">
              <a href="{{ route('blog.details', $row->slug) }}" class="hover:underline">{{ $row->title }}</a>
            </h4>
          </article>
        @endforeach
      </div>
    </div>
  @endforeach
</section>


@endsection
