@extends('user.layouts.app')
@section('meta-content')
 @php
    $settings = \App\Models\GeneralSetting::find(1);
    @endphp
<title>@if($settings){{$settings->site_title}}@endif</title>
<meta name="description" content="@if($settings){{$settings->meta_description}}@endif">
<meta name="title" content="@if($settings){{$settings->meta_title}}@endif">
@endsection
@section('content')
    <!-- breadcrumb-area -->
    
    <div class="page-title">
        <div class="container">
          <div class="row">
            <div class="col-md-12">
              <ul class="breadcrumb">
                <li><a href="{{route('index')}}">Home</a></li>
                <li><a href="">{{ $category->name }}</a></li>
                <li>{{ $subcategory->name }}</li>
              </ul>
            </div>
          </div>
        </div>
      </div>
    <!-- breadcrumb-area-end -->
    <!-- banner-post-area -->
    <section class="utf_block_wrapper">
        <div class="container">
          <div class="row">
            <div class="col-lg-8 col-md-12">
              <div class="block category-listing category-style2">
                <h3 class="utf_block_title"><span>{{$subcategory->name}}</span></h3>
                @foreach ($blogsbysubcategory as $row)
                <div class="utf_post_block_style post-list clearfix">
                  <div class="row">
                    <div class="col-lg-5 col-md-6">
                      <div class="utf_post_thumb thumb-float-style"> <a href="{{ route('blog.details', $row->slug) }}"> <img class="img-fluid" src="{{ asset('admin-assets/images/blogs') }}/{{ $row->feature_image }}" alt=""> </a>  <a class="utf_post_cat" href="#">{{$row->sub_category->name}}</a> </div>
                    </div>                
                    <div class="col-lg-7 col-md-6">
                      <div class="utf_post_content">
                        <h2 class="utf_post_title title-large"> <a href="{{ route('blog.details', $row->slug) }}">{{ $row->title }}</a> </h2>
                        <div class="utf_post_meta"> <span class="utf_post_author"><i class="fa fa-user"></i> <a href="#">Admin</a></span> <span class="utf_post_date"><i class="fa fa-clock-o"></i> {{ $row->created_at->format('d M, Y') }}</span> <span class="post-comment pull-right"><i class="fa fa-comments-o"></i> <a href="#" class="comments-link"><span>{{ $row->comments_count }}</span></a></span> </div>
                        <p>{!! \Illuminate\Support\Str::limit($row->description, 100) !!}</p>
                      </div>
                    </div>
                  </div>
                </div>      
                @endforeach   
              </div>
            </div>
            
            <div class="col-lg-4 col-md-12">
              <div class="sidebar utf_sidebar_right">
                
                
                <div class="widget color-default">
                  <h3 class="utf_block_title"><span>Categories</span></h3>
                  <div class="utf_list_post_block">
                    <ul class="utf_list_post">
                        @foreach($categories as $category)
                      <li class="clearfix">
                        <div class="utf_post_block_style post-float clearfix">
                          <div class="utf_post_thumb"> <a href="#"> <img class="img-fluid" src="{{ asset('admin-assets/images/categories') }}/{{$category->feature_image}}" alt=""> </a> </div>                      
                          <div class="utf_post_content">
                            <h2 class="utf_post_title title-small"> <a href="{{route('blogs.category', $category->slug)}}">{{$category->name}}</a> </h2>
                          </div>
                        </div>
                      </li>
                      @endforeach
                    </ul>
                  </div>
                </div>
    
                <div class="widget text-center"> <img class="banner img-fluid" src="images/banner-ads/ad-sidebar.png" alt=""> </div>
                <div class="widget m-bottom-0">
                  <h3 class="utf_block_title"><span>Newsletter</span></h3>
                  <div class="utf_newsletter_block">
                    <div class="utf_newsletter_introtext">
                      <h4>Subscribe Newsletter!</h4>
                      <p>Lorem ipsum dolor sit consectetur adipiscing elit Maecenas in pulvinar neque Nulla finibus lobortis pulvinar.</p>
                    </div>
                    <div class="utf_newsletter_form">
                      <form action="#" method="post">
                        <div class="form-group">
                          <input type="email" name="email" id="utf_newsletter_form-email" class="form-control form-control-lg" placeholder="E-Mail Address" autocomplete="off">
                          <button class="btn btn-primary">Subscribe</button>
                        </div>
                      </form>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
    </section>
@endsection
