@extends('user.layouts.app')
@section('content')
<!-- TradingView Widget BEGIN -->
<div class="tradingview-widget-container">
  <div class="tradingview-widget-container__widget"></div>
  <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/" rel="noopener nofollow" target="_blank"><span class="blue-text">Ticker tape by TradingView</span></a></div>
  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-ticker-tape.js" async>
  {
  "symbols": [
    {
      "proName": "FOREXCOM:SPXUSD",
      "title": "S&P 500 Index"
    },
    {
      "proName": "FOREXCOM:NSXUSD",
      "title": "US 100 Cash CFD"
    },
    {
      "proName": "FX_IDC:EURUSD",
      "title": "EUR to USD"
    },
    {
      "proName": "BITSTAMP:BTCUSD",
      "title": "Bitcoin"
    },
    {
      "proName": "BITSTAMP:ETHUSD",
      "title": "Ethereum"
    }
  ],
  "colorTheme": "light",
  "locale": "en",
  "largeChartUrl": "",
  "isTransparent": true,
  "showSymbolLogo": true,
  "displayMode": "adaptive"
}
  </script>
</div>
<!-- TradingView Widget END -->

<section class="bg-white py-16 font-serif text-gray-900 max-w-7xl mx-auto px-6">
  <header class="mb-14 border-b-4 border-gray-900 pb-3">
    <h2 class="text-5xl font-extrabold tracking-tight uppercase">Latest Headlines</h2>
  </header>

  <!-- Top featured article + headline column -->
  <div class="grid grid-cols-1 lg:grid-cols-3 gap-12 mb-16">

    @php $featured = $popularblogs->shift(); @endphp
    @if($featured)
    <article class="lg:col-span-2 border-t-8 border-gray-900 pt-8">
      <img src="{{ asset('admin-assets/images/blogs') }}/{{ $featured->feature_image }}" alt="{{ $featured->title }}"
        class="w-full h-[440px] object-cover mb-6 rounded-sm border border-gray-800" />
      <h3 class="text-6xl font-bold leading-tight mb-3 hover:text-gray-700 transition-colors duration-300">
        <a href="{{ route('blog.details', $featured->slug) }}">{{ $featured->title }}</a>
      </h3>
      <p class="italic text-sm text-gray-700 mb-6">
        By {{ $featured->author ?? 'Editor' }} | {{ $featured->created_at->format('F j, Y') }}
      </p>
      <p class="text-justify max-w-4xl leading-relaxed text-lg tracking-wide text-gray-800">
        {{ Str::limit(strip_tags($featured->excerpt ?? ''), 300) }}
      </p>
    </article>
    @endif

    <aside class="border-l-4 border-gray-900 pl-8 space-y-10">
      @foreach($popularblogs as $article)
      <article>
        <h4 class="text-2xl font-bold leading-snug mb-1 hover:text-gray-700 transition-colors duration-300">
          <a href="{{ route('blog.details', $article->slug) }}">{{ $article->title }}</a>
        </h4>
        <p class="italic text-xs text-gray-600 mb-2">
          By {{ $article->author ?? 'Editor' }} | {{ $article->created_at->format('M d, Y') }}
        </p>
        <p class="text-justify text-gray-800 leading-relaxed line-clamp-5">
          {{ Str::limit(strip_tags($article->excerpt ?? ''), 150) }}
        </p>
      </article>
      @endforeach
    </aside>
  </div>

  <!-- Bottom grid of articles -->
  <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-12 border-t border-gray-900 pt-12">
    @foreach($blogs as $item)
    <article class="group cursor-pointer">
      <img src="{{ asset('admin-assets/images/blogs') }}/{{ $item->feature_image }}" alt="{{ $item->title }}"
        class="w-full h-52 object-cover rounded-sm border border-gray-800 mb-4" />
      <span class="uppercase text-xs tracking-widest font-semibold text-gray-900 block mb-1 border-b border-gray-900 pb-1">
        {{ $item->category->name }}
      </span>
      <h5 class="text-xl font-bold leading-tight mb-2 hover:text-gray-700 transition-colors duration-300">
        <a href="{{ route('blog.details', $item->slug) }}">{{ $item->title }}</a>
      </h5>
      <p class="text-gray-700 leading-relaxed line-clamp-4 text-justify">
        {{ Str::limit(strip_tags($item->excerpt ?? ''), 140) }}
      </p>
    </article>
    @endforeach
  </div>
</section>

<section class="py-12 bg-white">
  <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
    <header class="mb-14 border-b-4 border-gray-900 pb-3">
    <h2 class="text-5xl font-extrabold tracking-tight uppercase">Spotlight Stories</h2>
  </header>

    <div class="swiper articleSwiper relative">
      <div class="swiper-wrapper">

        @foreach($popblogs as $row)
        <div class="swiper-slide group w-[280px] md:w-[360px] lg:w-[400px] rounded-lg overflow-hidden shadow-lg border border-gray-200 hover:shadow-2xl transition-shadow duration-300">
          <article class="relative">
            <!-- Image -->
            <img src="{{ asset('admin-assets/images/blogs') }}/{{ $row->feature_image }}" alt="{{ $row->title }}"
                 class="h-64 w-full object-cover transition-transform duration-700 ease-out group-hover:scale-105" />

            <!-- Overlay with subtle gradient -->
            <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent"></div>

            <!-- Content -->
            <div class="absolute bottom-0 left-0 right-0 p-5 bg-gradient-to-t from-black/70 to-transparent">
              <div class="flex items-center gap-3 mb-2">
                <span class="text-[11px] uppercase tracking-wide bg-white/90 text-gray-900 px-2 py-0.5 rounded-full font-semibold">
                  {{ $row->category->name }}
                </span>
                <time class="text-xs text-gray-300">{{ $row->created_at->format('d M, Y') }}</time>
              </div>
              <h3 class="text-white font-semibold text-lg leading-tight mb-1 line-clamp-2">
                {{ $row->title }}
              </h3>
              <a href="{{ route('blog.details', $row->slug) }}"
                 class="inline-block text-sm font-semibold text-white underline hover:text-gray-200 transition">
                Read More →
              </a>
            </div>
          </article>
        </div>
        @endforeach

      </div>

      <!-- Swiper Controls -->
      <div class="swiper-button-next text-gray-700 hover:text-gray-900"></div>
      <div class="swiper-button-prev text-gray-700 hover:text-gray-900"></div>
      <div class="swiper-pagination !bottom-[-30px]"></div>
    </div>
  </div>
</section>

<section class="bg-white max-w-7xl mx-auto px-8 py-12 font-serif text-black">

  <div class="grid grid-cols-1 lg:grid-cols-3 gap-12">

    <!-- Latest Posts (2/3 width) -->
    <div class="lg:col-span-2 space-y-10">

      <h2 class="text-4xl uppercase font-black tracking-tight border-b-4 border-black pb-3 max-w-max mb-10">
        Latest Posts
      </h2>

      <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-10">

        @foreach($topblogs as $row)
        <article class="border-4 border-black p-6 flex flex-col justify-between hover:bg-gray-50 transition-colors">
          
          <img src="{{ asset('admin-assets/images/blogs') }}/{{ $row->feature_image }}"
               alt="{{ $row->title }}"
               class="w-full h-48 object-cover mb-5" />
          
          <span class="uppercase text-xs font-semibold tracking-widest border border-black px-3 py-1 inline-block mb-4">
            {{ $row->category->name }}
          </span>

          <h3 class="text-2xl font-black uppercase leading-tight tracking-tight mb-4 text-justify">
            <a href="{{ route('blog.details', $row->slug) }}" class="hover:text-gray-700 transition-colors">
              {{ $row->title }}
            </a>
          </h3>

          <a href="{{ route('blog.details', $row->slug) }}"
             class="uppercase text-xs font-semibold tracking-widest border-b-2 border-black hover:border-gray-700 transition-colors self-start">
            Read More →
          </a>
        </article>
        @endforeach

      </div>
    </div>

    <!-- Sidebar (1/3 width) -->
    <aside>
        
       <!-- TradingView Widget BEGIN -->
<div class="tradingview-widget-container">
  <div class="tradingview-widget-container__widget"></div>
  <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/" rel="noopener nofollow" target="_blank"><span class="blue-text">Market data by TradingView</span></a></div>
  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-hotlists.js" async>
  {
  "exchange": "US",
  "colorTheme": "light",
  "dateRange": "12M",
  "showChart": true,
  "locale": "en",
  "largeChartUrl": "",
  "isTransparent": false,
  "showSymbolLogo": false,
  "showFloatingTooltip": false,
  "plotLineColorGrowing": "rgba(41, 98, 255, 1)",
  "plotLineColorFalling": "rgba(41, 98, 255, 1)",
  "gridLineColor": "rgba(240, 243, 250, 0)",
  "scaleFontColor": "#0F0F0F",
  "belowLineFillColorGrowing": "rgba(41, 98, 255, 0.12)",
  "belowLineFillColorFalling": "rgba(41, 98, 255, 0.12)",
  "belowLineFillColorGrowingBottom": "rgba(41, 98, 255, 0)",
  "belowLineFillColorFallingBottom": "rgba(41, 98, 255, 0)",
  "symbolActiveColor": "rgba(41, 98, 255, 0.12)",
  "width": "400",
  "height": "550"
}
  </script>
</div>
<!-- TradingView Widget END -->
      <h4 class="text-3xl uppercase font-black tracking-tight border-b-4 border-black pb-3 max-w-max mb-8">
        Categories
      </h4>

      <ul class="space-y-8">

        @foreach ($categories as $row)
        <li>
          <a href="{{route('blogs.category',$row->slug)}}"
             class="relative block border-4 border-black rounded-xl overflow-hidden p-5 hover:bg-gray-50 transition-colors focus:outline-none focus:ring-2 focus:ring-black">

            <!-- Background image -->
            <div class="absolute inset-0 bg-center bg-cover opacity-10"
                 style="background-image:url('{{ asset('admin-assets/images/categories') }}/{{ $row->feature_image }}');"></div>

            <!-- Overlay for text readability -->
            <div class="relative z-10 flex items-center justify-between">

              <div>
                <span class="text-black font-black uppercase text-lg tracking-tight">
                  {{ $row->name }}
                </span>
                <div class="text-sm text-gray-700 mt-1">{{ $row->blogs_count }} articles</div>
              </div>

              <span
                class="inline-flex items-center rounded-full border-2 border-black text-black text-xs px-3 py-1 font-bold hover:bg-black hover:text-white transition-colors">
                Explore
                <svg xmlns="http://www.w3.org/2000/svg" class="ml-1 h-4 w-4" fill="none" stroke="currentColor"
                     stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                  <path d="M9 18l6-6-6-6" />
                </svg>
              </span>
            </div>
          </a>
        </li>
        @endforeach

      </ul>
<!-- TradingView Widget BEGIN -->
<div class="tradingview-widget-container">
  <div class="tradingview-widget-container__widget"></div>
  <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/news-flow/?priority=top_stories" rel="noopener nofollow" target="_blank"><span class="blue-text">Top stories by TradingView</span></a></div>
  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-timeline.js" async>
  {
  "displayMode": "compact",
  "feedMode": "all_symbols",
  "colorTheme": "light",
  "isTransparent": false,
  "locale": "en",
  "width": 400,
  "height": 550
}
  </script>
</div>
<!-- TradingView Widget END -->
    </aside>

  </div>
</section>




@endsection