@extends('user.layouts.app')
@section('meta-content')

 @php
    $settings = \App\Models\GeneralSetting::find(1);
    @endphp
<title>@if($settings){{$settings->site_title}}@endif</title>
<meta name="description" content="@if($settings){{$settings->meta_description}}@endif">
<meta name="title" content="@if($settings){{$settings->meta_title}}@endif">


@endsection
@section('custom-styles')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

@endsection
@section('content')
 <nav class="bg-white py-3 border-b-4 border-black" aria-label="Breadcrumb">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <ol class="flex flex-wrap items-center gap-2 text-sm text-black font-serif uppercase tracking-tight">

      <!-- Home -->
      <li class="flex items-center gap-1 border-r-2 border-black pr-3">
        <a href="{{ route('index') }}" class="hover:text-gray-600 flex items-center gap-1">
          <svg class="h-4 w-4 shrink-0" fill="currentColor" viewBox="0 0 20 20" class="text-black">
            <path d="M10.707 1.707a1 1 0 00-1.414 0L2 9h3v6a1 1 0 001 1h8a1 1 0 001-1V9h3l-7.293-7.293z" />
          </svg>
          <span class="whitespace-nowrap">Home</span>
        </a>
      </li>

      <!-- Divider -->
      <li class="text-black">
        <svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
          <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L11.586 9 7.293 4.707a1 1 0 111.414-1.414l5 5a1 1 0 010 1.414l-5 5a1 1 0 01-1.414 0z" clip-rule="evenodd" />
        </svg>
      </li>

      <!-- Current Category -->
      <li class="flex items-center">
        <span class="text-black font-serif uppercase tracking-tight">{{ $page->title }}</span>
      </li>
    </ol>
  </div>
</nav>
 <section class="bg-white py-12">
  <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
    
    <!-- Grid Layout -->
    <div class="grid grid-cols-1 lg:grid-cols-12 gap-12">
      
      <!-- 📝 Blog Content -->
      <div class="lg:col-span-8">
        
        <!-- Title -->
        <h1 class="text-3xl md:text-4xl font-extrabold tracking-tight text-gray-900 mb-6 leading-tight">
          {{ $page->title }}
        </h1>

       
        @php
        if (!function_exists('convertBootstrapToTailwind')) {
            function convertBootstrapToTailwind($content)
            {
                // Mapping of Bootstrap → Tailwind classes
                $map = [
                    // Grid system
                    'row'               => 'flex flex-wrap -mx-2',
                    'col'               => 'px-2',
                    'col-12'            => 'w-full',
                    'col-6'             => 'w-1/2',
                    'col-4'             => 'w-1/3',
                    'col-3'             => 'w-1/4',
        
                    // Typography
                    'text-center'       => 'text-center',
                    'text-left'         => 'text-left',
                    'text-right'        => 'text-right',
                    'font-weight-bold'  => 'font-bold',
        
                    // Spacing (basic common ones)
                    'mt-3'              => 'mt-3',
                    'mb-3'              => 'mb-3',
                    'p-3'               => 'p-3',
                    'pt-3'              => 'pt-3',
                    'pb-3'              => 'pb-3',
        
                    // Buttons
                    'btn'               => 'inline-block px-4 py-2 rounded font-semibold transition',
                    'btn-primary'       => 'bg-blue-600 text-white hover:bg-blue-700',
                    'btn-secondary'     => 'bg-gray-600 text-white hover:bg-gray-700',
                    'btn-success'       => 'bg-green-600 text-white hover:bg-green-700',
                    'btn-danger'        => 'bg-red-600 text-white hover:bg-red-700',
        
                    // Images
                    'img-fluid'         => 'max-w-full h-auto',
        
                    // Alerts
                    'alert'             => 'px-4 py-3 rounded relative mb-4',
                    'alert-primary'     => 'bg-blue-100 text-blue-800',
                    'alert-success'     => 'bg-green-100 text-green-800',
                    'alert-danger'      => 'bg-red-100 text-red-800',
                    'alert-warning'     => 'bg-yellow-100 text-yellow-800',
                ];
        
                // Replace Bootstrap classes with Tailwind equivalents
                foreach ($map as $bootstrap => $tailwind) {
                    $pattern = '/\b' . preg_quote($bootstrap, '/') . '\b/';
                    $content = preg_replace($pattern, $tailwind, $content);
                }
        
                return $content;
            }
        }
        @endphp
        <!-- Blog Content -->
        <article class="prose prose-lg prose-gray max-w-none">
          {!! convertBootstrapToTailwind($page->details) !!}
        </article>
        
      </div>
    </div>
    
  </div>
 </section>
<!-- blog-details-area-end -->

@endsection