@extends('user.layouts.app')
@section('meta-content')
 @php
    $settings = \App\Models\GeneralSetting::find(1);
    @endphp
<title>@if($settings){{$settings->site_title}}@endif</title>
<meta name="description" content="@if($settings){{$settings->meta_description}}@endif">
<meta name="title" content="@if($settings){{$settings->meta_title}}@endif">
@endsection

@section('content')
<!-- breadcrumb-area -->
<nav class="bg-white border-b-4 border-black py-3" aria-label="Breadcrumb">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <ol class="flex flex-wrap items-center gap-2 text-sm font-serif uppercase tracking-tight text-black">

      <!-- Home -->
      <li class="flex items-center gap-1 border-r-2 border-black pr-3">
        <a href="{{ route('index') }}" class="hover:text-gray-600 flex items-center gap-1">
          <svg class="h-4 w-4 shrink-0" fill="currentColor" viewBox="0 0 20 20" class="text-black">
            <path d="M10.707 1.707a1 1 0 00-1.414 0L2 9h3v6a1 1 0 001 1h8a1 1 0 001-1V9h3l-7.293-7.293z" />
          </svg>
          <span class="whitespace-nowrap">Home</span>
        </a>
      </li>

      <!-- Divider -->
      <li class="text-black">
        <svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
          <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L11.586 9 7.293 4.707a1 1 0 111.414-1.414l5 5a1 1 0 010 1.414l-5 5a1 1 0 01-1.414 0z" clip-rule="evenodd" />
        </svg>
      </li>

      <!-- Stores -->
      <li class="flex items-center border-r-2 border-black pr-3">
        <span class="whitespace-nowrap">{{ __('Stores') }}</span>
      </li>

      <!-- Divider -->
      <li class="text-black">
        <svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
          <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L11.586 9 7.293 4.707a1 1 0 111.414-1.414l5 5a1 1 0 010 1.414l-5 5a1 1 0 01-1.414 0z" clip-rule="evenodd" />
        </svg>
      </li>

      <!-- Current Store -->
      <li class="flex items-center">
        <span class="whitespace-nowrap font-serif uppercase tracking-tight text-black">{{ $store->name }}</span>
      </li>

    </ol>
  </div>
</nav>

<section class="py-16 bg-white font-serif text-black max-w-7xl mx-auto px-6">

  <!-- Store Info -->
  <div class="flex flex-col sm:flex-row items-center gap-6 mb-16 text-center sm:text-left border-4 border-black p-6">
    <img src="{{ asset('admin-assets/images/stores') }}/{{ $store->feature_image }}" alt="Store Logo" class="h-24 w-24 object-contain rounded-md " />
    <div class="">
      <h1 class="text-4xl uppercase tracking-tight font-black mb-4 border-t-8 border-black pt-3">{{ $store->name }}</h1>
      <p class="text-base leading-relaxed">
        {{ $store->description }}
      </p>
    </div>
  </div>

  <!-- Coupons & Deals Grid -->
  <div class="flex flex-col space-y-6">
  @foreach ($coupons as $row)
   <div class="flex flex-col md:flex-row border-4 border-black p-6 bg-white hover:border-gray-600 transition-colors duration-300 relative md:items-center md:justify-between md:space-x-6 space-y-4 md:space-y-0">
  
  <!-- Left side: Texts -->
  <div class="flex-1">
    <p class="text-xl font-bold uppercase tracking-tight text-justify">{{ $row->title }}</p>
    <h3 class="text-sm uppercase tracking-tight mb-1 text-black">{{ $row->description }}</h3>
  </div>
  
  <!-- Right side: Button -->
  <div class="flex-shrink-0 w-full md:w-40">
    @if($row->code)
      <button
        onclick="copyCoupon(this)"
        data-code="{{ $row->code }}"
        data-url="{{ $row->url }}"
        class="w-full py-3 text-center font-bold tracking-widest bg-black text-white rounded hover:bg-gray-900 transition">
        <span class="block group-hover:hidden">Show Code</span>
        <span class="hidden group-hover:block">{{ $row->code }}</span>
      </button>
      <p class="mt-2 text-xs text-gray-500 italic text-center">Click to copy</p>
    @else
      <a href="{{ $row->url }}" target="_blank" rel="noopener noreferrer"
         class="block w-full py-3 text-center font-bold tracking-widest bg-black text-white rounded hover:bg-gray-900 transition">
         Get Deal
      </a>
    @endif
  </div>

</div>

  @endforeach
</div>


</section>


@endsection
@section('custom-scripts')
  
@endsection
