<?php

use App\Http\Controllers\FacebookLoginController;
use App\Http\Controllers\GoogleController;
use App\Http\Controllers\PushNotificationController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\BlogController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\CouponController;
use App\Http\Controllers\Admin\EventController;
use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\StoreController;
use App\Http\Controllers\Admin\SubCategoryController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\PermissionsController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Home\HomeController;
use App\Http\Controllers\Home\SubscriberController;
use App\Http\Controllers\Auth\AuthController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });

Auth::routes();
Route::get('auth/google', [GoogleController::class, 'signInwithGoogle']);
Route::get('callback/google', [GoogleController::class, 'callbackToGoogle']);
Route::get('/auth/facebook', [FacebookLoginController::class, 'redirectToFacebook'])->name('auth.facebook');
Route::get('/auth/facebook/callback', [FacebookLoginController::class, 'handleFacebookCallback']);
Route::get('hub/admin',[AuthController::class,'LoginView'])->name('admin.login.view');
Route::post('/admin-login-validate',[AuthController::class,'ValidateLogin'])->name('admin.login.validate');
Route::get('/admin-logout',[AuthController::class,'Logout'])->name('admin.logout');


/**
 * Admin Routes
 */
Route::group(['prefix' => 'admin','middleware'=>'login'], function ($route) {
    $route->get('/', [AdminController::class, 'Dashboard'])->name('dashboard.index');
    $route->resource('/users', UserController::class);
    $route->resource('roles', RoleController::class);
    $route->resource('categories', CategoryController::class);
    $route->resource('subcategories', SubCategoryController::class);
    $route->resource('events', EventController::class);
    $route->resource('stores', StoreController::class);
    $route->resource('coupons', CouponController::class);
    $route->resource('blogs', BlogController::class);
    $route->resource('pages', PageController::class);
    $route->get('/sub-category-api', [BlogController::class, 'subCategoryApi'])->name('sub-category-api');
    $route->get('site-content', [SettingController::class, 'Sitecontent'])->name('site.content');
    $route->get('/store-coupons/{id}',[StoreController::class,'coupons'])->name('store_coupon');
    $route->get('/update-order',[StoreController::class,'update_order'])->name('update_order');
    $route->post('store-content', [SettingController::class, 'storeSiteContent'])->name('store.content');
    $route->post('update-content', [SettingController::class, 'updateSiteContent'])->name('update.content');
    $route->get('general-settings', [SettingController::class, 'generalSetting'])->name('general.settings');
    $route->post('store-general-settings', [SettingController::class, 'storeSetting'])->name('store.general.settings');
    $route->post('update-general-settings', [SettingController::class, 'updateSetting'])->name('update.general.settings');
    $route->get('theme-settings', [SettingController::class, 'themeSetting'])->name('theme.settings');
    $route->post('store-theme-settings', [SettingController::class, 'storethemeSetting'])->name('store.theme.settings');
    $route->post('update-theme-settings', [SettingController::class, 'updatethemeSetting'])->name('update.theme.settings');
    $route->get('query-settings', [SettingController::class, 'querySetting'])->name('query.settings');
    $route->post('store-query-settings', [SettingController::class, 'storequerySetting'])->name('store.query.settings');
    $route->post('update-query-settings', [SettingController::class, 'updatequerySetting'])->name('update.query.settings');
    $route->get('add-social-media', [SettingController::class, 'AddSocialMedia'])->name('add.social.media');
    $route->get('social-media', [SettingController::class, 'SocialMedia'])->name('social.media');
    $route->post('store-social-media', [SettingController::class, 'storeSocialMedia'])->name('store.social.media');
    $route->get('edit-social-media/{id}', [SettingController::class, 'EditSocialMedia'])->name('social.media.edit');
    $route->get('del-social-media/{id}', [SettingController::class, 'DelSocialMedia'])->name('social.media.destroy');
    $route->post('update-social-media', [SettingController::class, 'updateSocialMedia'])->name('update.social.media');
    $route->get('clear-cache', function () {
        \Cache::flush();
        return redirect()->route('dashboard.index');
    })->name('cache.clear');

});

/**
 * User Routes
 */

Route::get('/', [HomeController::class, 'Index'])->name('index');
Route::get('/prayer-times', [HomeController::class, 'PrayerTimes'])->name('prayer.times');
Route::get('/gold-rates', [HomeController::class, 'GoldRates'])->name('gold.rates');
Route::get('/forex-crypto', [HomeController::class, 'ForexCrypto'])->name('forex.crypto');
Route::get('/get-gold-price', [HomeController::class, 'get_gold_price'])->name('get.gold.price');
Route::get('/topics/{slug}', [HomeController::class, 'BlogsByCategory'])->name('blogs.category');
Route::get('/topics/{categoryslug}/{subcategoryslug}', [HomeController::class, 'BlogsBySubCategory'])->name('blogs.subcategory');
Route::get('/topic/{slug}', [HomeController::class, 'BlogProfile'])->name('blog.details');
Route::post('/comment/store', [HomeController::class, 'StoreComment'])->name('comment.store');
Route::post('/reply/store', [HomeController::class, 'StoreReply'])->name('reply.store');
Route::get('/comment/delete', [HomeController::class, 'DeleteComment'])->name('comment.delete');
Route::get('/reply/delete', [HomeController::class, 'DeleteReply'])->name('reply.delete');
Route::get('/comment/like', [HomeController::class, 'LikeComment'])->name('comment.like');
Route::get('/reply/like', [HomeController::class, 'LikeReply'])->name('reply.like');
Route::get('/brands', [HomeController::class, 'stores'])->name('frontend-stores');
Route::get('/brand/{slug}', [HomeController::class, 'StoreProfile'])->name('store.profile');
Route::get('/get-stores', [HomeController::class, 'getstores'])->name('get-stores');
Route::get('/get-blogs', [HomeController::class, 'getblogs'])->name('get-blogs');
Route::get('info/{slug}', [HomeController::class, 'Page'])->name('page');
Route::get('/update_coupon_used', [HomeController::class, 'update_coupon_used'])->name('update_coupon_used');
Route::get('/blog-save', [HomeController::class, 'BlogSave'])->name('blog.save');
Route::get('/send-notification', [PushNotificationController::class, 'sendPushNotification']);
Route::post('/subscriber/store', [SubscriberController::class, 'StoreSubscriber'])->name('subscriber.store');

/**
 * User Dashboard Routes
 */
Route::get('/dashboard', [App\Http\Controllers\HomeController::class, 'index'])->name('dashboard');
Route::get('/edit-profile/{id}', [App\Http\Controllers\HomeController::class, 'EditProfile'])->name('edit.profile');
Route::post('/user-update', [App\Http\Controllers\HomeController::class, 'UserUpdate'])->name('user.update');


