
<?php $__env->startSection('meta-content'); ?>
 <?php
    $settings = \App\Models\GeneralSetting::find(1);
    ?>
<title><?php if($settings): ?><?php echo e($settings->site_title); ?><?php endif; ?></title>
<meta name="description" content="<?php if($settings): ?><?php echo e($settings->meta_description); ?><?php endif; ?>">
<meta name="title" content="<?php if($settings): ?><?php echo e($settings->meta_title); ?><?php endif; ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
  <nav class="bg-gradient-to-r from-[#FF2A26] to-white dark:from-[#FF2A26] dark:to-slate-600 py-3" aria-label="Breadcrumb">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <ol class="flex flex-wrap items-center gap-2 text-sm text-slate-700 dark:text-slate-200">

      <!-- Home -->
      <li class="flex items-center gap-1">
        <a href="<?php echo e(route('index')); ?>" class="hover:text-indigo-600 dark:hover:text-white flex items-center gap-1">
          <svg class="h-4 w-4 shrink-0" fill="currentColor" viewBox="0 0 20 20">
            <path d="M10.707 1.707a1 1 0 00-1.414 0L2 9h3v6a1 1 0 001 1h8a1 1 0 001-1V9h3l-7.293-7.293z" />
          </svg>
          <span class="whitespace-nowrap">Home</span>
        </a>
      </li>

      <!-- Divider -->
      <li class="text-slate-400 dark:text-slate-600">
        <svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
          <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L11.586 9 7.293 4.707a1 1 0 111.414-1.414l5 5a1 1 0 010 1.414l-5 5a1 1 0 01-1.414 0z" clip-rule="evenodd" />
        </svg>
      </li>

      <!-- Stores -->
      <li class="flex items-center">
        <a href="javascript:;" class="hover:text-indigo-600 dark:hover:text-white whitespace-nowrap"><?php echo e($category->name); ?></a>
      </li>

    

    </ol>
  </div>
</nav>

<!-- breadcrumb-area-end -->
<!-- banner-post-area -->
<section class="py-12 bg-white dark:bg-slate-950">
  <?php $__currentLoopData = $subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
  <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
    <h2 class="text-2xl md:text-3xl font-bold mb-8 py-6 inline-block relative">
      <?php echo e($subcategory->name); ?>

      <span class="absolute left-0 -bottom-1 w-full h-1 bg-indigo-600 rounded-full"></span>
    </h2>
    
    <!-- Lower Grid (8 articles in masonry-like grid) -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8">
      <?php
      $categoryblogs = \App\Models\Blog::with([
          'category:id,name',
          'sub_category:id,name',
      ])
          ->inRandomOrder()
          ->where('blogs.sub_category_id', $subcategory->id)
          ->get();

      
  ?>
  <?php $__currentLoopData = $categoryblogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <article class="group" data-aos="fade-up">
        <img src="<?php echo e(asset('admin-assets/images/blogs')); ?>/<?php echo e($row->feature_image); ?>" class="w-full h-40 object-cover rounded group-hover:scale-105 transition">
        <div class="mt-3">
          <span class="text-xs uppercase text-slate-500"><?php echo e($row->sub_category->name); ?></span>
          <h4 class="mt-1 text-base font-semibold">
            <a href="<?php echo e(route('blog.details', $row->slug)); ?>" class="hover:underline"><?php echo e($row->title); ?></a>
          </h4>
        </div>
      </article>

      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>  
    </div>
  </div>
  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dealqmki/blogzcenter.com/resources/views/user/pages/blogs-by-category.blade.php ENDPATH**/ ?>