
<?php $__env->startSection('custom-styles'); ?>
    <!-- Bootstrap Select Css -->
    <link href="<?php echo e(asset('admin-assets/css/bootstrap-select.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card">
                <div class="header">
                    <h2><strong>Edit </strong> Store</h2>

                </div>
                <div class="mt-2">
                    <?php echo $__env->make('admin.layouts.partials.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="body">
                    <?php if(count($errors) > 0): ?>
                        <div class="alert alert-danger">
                            <strong>Whoops!</strong> There were some problems with your input.<br><br>
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <form method="POST" action="<?php echo e(route('stores.update', $store->id)); ?>" autocomplete="off"
                        enctype="multipart/form-data">
                        <?php echo method_field('patch'); ?>
                        <?php echo csrf_field(); ?>
                        <label for="name">Name</label>
                        <div class="form-group">
                            <input type="text" id="name" class="form-control" placeholder="Enter Store Name"
                                name="name" value="<?php echo e($store->name); ?>" required>
                            <?php if($errors->has('name')): ?>
                                <span class="text-danger"><?php echo e($errors->first('name')); ?></span>
                            <?php endif; ?>
                        </div>
                        <label class="">Category</label>
                        <select class="form-control show-tick" name="category_id">
                            <option value="<?php echo e($store->category_id); ?>"><?php echo e($store->category->name); ?></option>
                            <option value="">--select Category--</option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>"><?php echo e($category); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <label class="">Event</label>
                        <select class="form-control show-tick" name="event_id">
                            <option value="<?php echo e($store->event_id); ?>"><?php echo e($store->event ? $store->event->name : '-'); ?></option>
                            <option value="">--select Event--</option>
                            <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>"><?php echo e($event); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <label for="url">Url</label>
                        <div class="form-group">
                            <input type="text" id="url" class="form-control" placeholder="Enter Store Url"
                                name="url" value="<?php echo e($store->url); ?>">
                            <?php if($errors->has('url')): ?>
                                <span class="text-danger"><?php echo e($errors->first('url')); ?></span>
                            <?php endif; ?>
                        </div>
                        <label for="description">Description</label>
                        <div class="form-group">
                            <textarea id="description" class="form-control" name="description" placeholder="Entere Store Description"><?php echo e($store->description); ?></textarea>
                            <?php if($errors->has('description')): ?>
                                <span class="text-danger"><?php echo e($errors->first('description')); ?></span>
                            <?php endif; ?>
                        </div>
                        <label for="blog_description">Blog Description</label>
                        <div class="form-group">
                            <textarea id="blog_description" class="form-control" name="blog_description" placeholder="Entere Blog Description"><?php echo e($store->description); ?></textarea>
                            <?php if($errors->has('blog_description')): ?>
                                <span class="text-danger"><?php echo e($errors->first('blog_description')); ?></span>
                            <?php endif; ?>
                        </div>
                        <label for="meta_title">Meta Title</label>
                        <div class="form-group">
                            <input type="text" id="meta_title" class="form-control" placeholder="Enter Meta Title"
                                name="meta_title" value="<?php echo e($store->meta_title); ?>">
                            <?php if($errors->has('meta_title')): ?>
                                <span class="text-danger"><?php echo e($errors->first('meta_title')); ?></span>
                            <?php endif; ?>
                        </div>
                        <label for="meta_description">Meta Description</label>
                        <div class="form-group">
                            <textarea id="meta_description" class="form-control" name="meta_description" placeholder="Entere Meta Description"><?php echo e($store->meta_description); ?></textarea>
                            <?php if($errors->has('meta_description')): ?>
                                <span class="text-danger"><?php echo e($errors->first('meta_description')); ?></span>
                            <?php endif; ?>
                        </div>
                        <label for="feature_image">Feature Image</label>
                        <div class="form-group">
                            <input type="file" id="feature_image" class="form-control" name="featured_image">

                        </div>

                        <button type="submit" class="btn btn-raised btn-primary  waves-effect">Save</button>
                        <a href="<?php echo e(route('stores.index')); ?>" class="btn btn-default">Back</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dealqmki/blogzcenter.com/resources/views/admin/pages/stores/edit.blade.php ENDPATH**/ ?>