
<?php $__env->startSection('meta-content'); ?>
 <?php
    $settings = \App\Models\GeneralSetting::find(1);
    ?>
<title><?php if($settings): ?><?php echo e($settings->site_title); ?><?php endif; ?></title>
<meta name="description" content="<?php if($settings): ?><?php echo e($settings->meta_description); ?><?php endif; ?>">
<meta name="title" content="<?php if($settings): ?><?php echo e($settings->meta_title); ?><?php endif; ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
 <!-- breadcrumb-area -->
 <nav class="bg-gradient-to-r from-[#FF2A26] to-white dark:from-[#FF2A26] dark:to-slate-600 py-3" aria-label="Breadcrumb">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <ol class="flex flex-wrap items-center gap-2 text-sm text-slate-700 dark:text-slate-200">

      <!-- Home -->
      <li class="flex items-center gap-1">
        <a href="<?php echo e(route('index')); ?>" class="hover:text-indigo-600 dark:hover:text-white flex items-center gap-1">
          <svg class="h-4 w-4 shrink-0" fill="currentColor" viewBox="0 0 20 20">
            <path d="M10.707 1.707a1 1 0 00-1.414 0L2 9h3v6a1 1 0 001 1h8a1 1 0 001-1V9h3l-7.293-7.293z" />
          </svg>
          <span class="whitespace-nowrap">Home</span>
        </a>
      </li>

      <!-- Divider -->
      <li class="text-slate-400 dark:text-slate-600">
        <svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
          <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L11.586 9 7.293 4.707a1 1 0 111.414-1.414l5 5a1 1 0 010 1.414l-5 5a1 1 0 01-1.414 0z" clip-rule="evenodd" />
        </svg>
      </li>

      <!-- Stores -->
      <li class="flex items-center">
        <a href="javascript:;" class="hover:text-indigo-600 dark:hover:text-white whitespace-nowrap">Stores</a>
      </li>

      <!-- Divider -->
      <li class="text-slate-400 dark:text-slate-600">
        <svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
          <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L11.586 9 7.293 4.707a1 1 0 111.414-1.414l5 5a1 1 0 010 1.414l-5 5a1 1 0 01-1.414 0z" clip-rule="evenodd" />
        </svg>
      </li>

      <!-- Current Store -->
      <li class="flex items-center">
        <a href="javascript:;" class="hover:text-indigo-600 dark:hover:text-white whitespace-nowrap"><?php echo e($store->name); ?></a>
      </li>

    </ol>
  </div>
</nav>

<section class="py-10 bg-white dark:bg-slate-950">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

   
    
       <!-- Store Info -->
      <div class="flex flex-col sm:flex-row items-center gap-4 mb-10 text-center sm:text-left">
        <img src="<?php echo e(asset('admin-assets/images/stores')); ?>/<?php echo e($store->feature_image); ?>" alt="Store Logo" class="h-20 w-20 object-contain rounded-md shadow-sm border">
        <div>
          <h1 class="text-2xl font-bold text-slate-800 dark:text-white"><?php echo e($store->name); ?></h1>
          <p class="text-slate-600 dark:text-slate-300 max-w-xl">
            Discover the latest <?php echo e($store->name); ?> coupons, promo codes & deals for exclusive savings on your favorite products.
          </p>
        </div>
      </div>
    <!-- Coupons & Deals -->
    <div class="grid grid-cols-1 lg:grid-cols-12 gap-10">
      <!-- Left Column: 10 cols for coupons -->
      <div class="lg:col-span-10">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
          <?php $__currentLoopData = $coupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <div class="border p-4 rounded-lg bg-slate-50 dark:bg-slate-900 shadow-sm relative group">
                <p class="text-sm text-slate-500 mb-2"><?php echo e($row->title); ?></p>
                <h3 class="text-lg font-semibold mb-4"><?php echo e($row->description); ?></h3>
            
                <?php if($row->code): ?>
                <div class="relative w-full">
                  <button
                    onclick="copyCoupon(this)"
                    data-code="<?php echo e($row->code); ?>"
                    data-url="<?php echo e($row->url); ?>"
                    class="relative w-full py-2 text-center font-semibold text-white bg-slate-800 rounded hover:bg-slate-700 transition group">
                    <span class="block group-hover:hidden">Show Code</span>
                    <span class="hidden group-hover:block tracking-widest"><?php echo e($row->code); ?></span>
                  </button>
            
                  <div class="absolute left-1/2 transform -translate-x-1/2 mt-2 text-xs text-slate-500 opacity-0 group-hover:opacity-100 transition">
                    Click to copy
                  </div>
                </div>
                <?php else: ?>
                <button
                  onclick="copyDeal(this)"
                  data-code="FREESHIP"
                  data-url="<?php echo e($row->url); ?>"
                  class="w-full py-2 font-semibold text-white bg-[#F92925] hover:bg-[#F92925] rounded transition">
                  Get Deal
                </button>
                <?php endif; ?>
              </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    
          
    
        </div>
      </div>
    
      <!-- Right Column: 2 cols for banner -->
      <div class="lg:col-span-2">
        <?php if(url()->current() == 'https://blogzcenter.com/brand/viator-coupon-code'): ?>
        <div data-id=viator-banner data-partner-id=P00259606 data-url="https://www.viator.com/" data-banner-width=120
          data-banner-height=600 data-banner-language=en data-banner-selection=banner1></div>
        <?php endif; ?>
      </div>
    </div>
    
    
  </div>
</section>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-scripts'); ?>
  
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dealqmki/blogzcenter.com/resources/views/user/pages/store-profile.blade.php ENDPATH**/ ?>