
<?php $__env->startSection('meta-content'); ?>
 <?php
    $settings = \App\Models\GeneralSetting::find(1);
    ?>
<title><?php if($settings): ?><?php echo e($settings->site_title); ?><?php endif; ?></title>
<meta name="description" content="<?php if($settings): ?><?php echo e($settings->meta_description); ?><?php endif; ?>">
<meta name="title" content="<?php if($settings): ?><?php echo e($settings->meta_title); ?><?php endif; ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
 <nav class="bg-white py-3 border-b-4 border-black" aria-label="Breadcrumb">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <ol class="flex flex-wrap items-center gap-2 text-sm text-black font-serif uppercase tracking-tight">

      <!-- Home -->
      <li class="flex items-center gap-1 border-r-2 border-black pr-3">
        <a href="<?php echo e(route('index')); ?>" class="hover:text-gray-600 flex items-center gap-1">
          <svg class="h-4 w-4 shrink-0" fill="currentColor" viewBox="0 0 20 20" class="text-black">
            <path d="M10.707 1.707a1 1 0 00-1.414 0L2 9h3v6a1 1 0 001 1h8a1 1 0 001-1V9h3l-7.293-7.293z" />
          </svg>
          <span class="whitespace-nowrap">Home</span>
        </a>
      </li>

      <!-- Divider -->
      <li class="text-black">
        <svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
          <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L11.586 9 7.293 4.707a1 1 0 111.414-1.414l5 5a1 1 0 010 1.414l-5 5a1 1 0 01-1.414 0z" clip-rule="evenodd" />
        </svg>
      </li>

      <!-- Current Category -->
      <li class="flex items-center">
        <span class="text-black font-serif uppercase tracking-tight"><?php echo e($category->name); ?></span>
      </li>
    </ol>
  </div>
</nav>

<section class="py-16 bg-white font-serif text-black">
  <?php $__currentLoopData = $subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="max-w-7xl mx-auto px-6 mb-16">
      <h2 class="text-3xl uppercase tracking-tight font-black border-t-8 border-black pt-3 mb-8 text-justify">
        <?php echo e($subcategory->name); ?>

      </h2>

      <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8">
        <?php
          $categoryblogs = \App\Models\Blog::with(['category:id,name', 'sub_category:id,name'])
              ->inRandomOrder()
              ->where('blogs.sub_category_id', $subcategory->id)
              ->get();
        ?>
        <?php $__currentLoopData = $categoryblogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <article class="border-4 border-black p-4 hover:border-gray-700 transition-colors duration-300">
            <img src="<?php echo e(asset('admin-assets/images/blogs')); ?>/<?php echo e($row->feature_image); ?>" alt="<?php echo e($row->title); ?>" class="w-full h-40 object-cover mb-3" />
            <span class="text-xs uppercase tracking-tight font-semibold block mb-1"><?php echo e($row->sub_category->name); ?></span>
            <h4 class="text-lg font-bold uppercase tracking-tight text-justify">
              <a href="<?php echo e(route('blog.details', $row->slug)); ?>" class="hover:underline"><?php echo e($row->title); ?></a>
            </h4>
          </article>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
    </div>
  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</section>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dealqmki/brieflylive.com/resources/views/user/pages/blogs-by-category.blade.php ENDPATH**/ ?>