<!-- Footer -->
<footer class="bg-slate-100 dark:bg-slate-950 border-t border-slate-200 dark:border-slate-800 mt-10">
    <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8 py-12 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
      
      <!-- Column 1: Logo + About + Social -->
      <div>
        <div class="flex items-center gap-2 mb-4">
            <img src="<?php if($settings): ?><?php echo e(asset('admin-assets/images/logos')); ?>/<?php echo e($settings->footer_logo); ?><?php endif; ?>" alt="Logo" class="h-10 object-contain" />
        </div>
        <p class="text-sm text-slate-600 dark:text-slate-400 mb-4">
            Your Central Hub for News, Trends & Smart Shopping
        </p>
        <div class="flex gap-3">
          <!-- Social Icons -->
          <a href="#" class="p-2 rounded-md hover:bg-slate-200 dark:hover:bg-slate-800" aria-label="Twitter">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 1227" class="h-4 w-4" fill="currentColor"><path d="M714 519 1160 0H996L665 388 384 0H0l464 622-413 481h164l312-363 296 363h384L714 519Zm-106 123-36-47-339 396h-90l381-431-381-459h90l334 415 38 48 363-415h90L608 642l383 460h-90L608 642Z"/></svg>
          </a>
          <a href="#" class="p-2 rounded-md hover:bg-slate-200 dark:hover:bg-slate-800" aria-label="Facebook">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" class="h-4 w-4" fill="currentColor"><path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S262.43 0 225.36 0C149.1 0 100.2 44.38 100.2 124.72v70.62H12v92.66h88.2V512h107.13V288z"/></svg>
          </a>
          <a href="#" class="p-2 rounded-md hover:bg-slate-200 dark:hover:bg-slate-800" aria-label="Instagram">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" class="h-4 w-4" fill="currentColor"><path d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9S160.5 370.9 224.1 370.9 339 319.6 339 255.9 287.7 141 224.1 141zm0 189.6c-41.2 0-74.7-33.4-74.7-74.7s33.4-74.7 74.7-74.7 74.7 33.4 74.7 74.7-33.5 74.7-74.7 74.7zM370.5 136.7c0 14.9-12 26.9-26.9 26.9-14.9 0-26.9-12-26.9-26.9 0-14.9 12-26.9 26.9-26.9 14.9 0 26.9 12 26.9 26.9z"/></svg>
          </a>
          <a href="#" class="p-2 rounded-md hover:bg-slate-200 dark:hover:bg-slate-800" aria-label="GitHub">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512" class="h-4 w-4" fill="currentColor"><path d="M165.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3.3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-6.7c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2 .7-2-1.3-4.3-4.3-5.2-2.6-.7-5.5.3-6.2 2.3zm44.2-1.7c-2.9.7-4.9 2.6-4.6 4.9.3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.9-.3-2-3-3.3-5.9-2.6zM244 8C106 8 0 113.7 0 252c0 108.9 70.5 201.4 168.2 234 12.6 2.3 17.1-5.6 17.1-12.1 0-6.2-.3-26.6-.3-48.2-61 13.5-73.8-26.2-73.8-26.2-11.3-28.8-27.6-36.5-27.6-36.5-22.6-15.5 1.6-15.2 1.6-15.2 25 1.6 38.2 25.9 38.2 25.9 22.3 38.2 58.6 27.2 72.9 20.8 2.3-16.1 8.7-27.2 15.9-33.5-48.7-5.2-99.8-24.3-99.8-108.4 0-24 8.7-43.6 23-59-2.3-5.6-10-28.8 2.3-59 0 0 18.7-6.2 61.3 22.6 18-5.2 37.2-7.7 56.2-7.7 19 0 38.2 2.6 56.2 7.7 42.6-28.8 61.3-22.6 61.3-22.6 12.3 30.2 4.6 53.4 2.3 59 14.2 15.5 23 35 23 59 0 84.5-51.3 103.2-100.1 108.4 9 7.7 16.8 22.9 16.8 46.5 0 33.5-.3 60.3-.3 68.5 0 6.5 4.6 14.4 17.4 12.1C425.5 453.7 496 360.9 496 252 496 113.7 383 8 244 8z"/></svg>
          </a>
        </div>
      </div>
  
      <!-- Column 2: Categories -->
      <div>
        <h4 class="font-semibold mb-4">Categories</h4>
        <ul class="space-y-2 text-sm">
            <?php
            $categories = \App\Models\Category::select('id', 'slug', 'name')->limit(5)->get();
        ?>
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <li><a href="<?php echo e(route('blogs.category',$category->slug)); ?>" class="hover:text-slate-900 dark:hover:text-white"><?php echo e($category->name); ?></a></li>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
      </div>
  
      <!-- Column 3: Information -->
      <div>
        <h4 class="font-semibold mb-4">Information</h4>
        <ul class="space-y-2 text-sm">
            <?php
                                    $pages = \App\Models\Page::all();
                                ?>
                                <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a class="hover:text-slate-900 dark:hover:text-white" href="<?php echo e(route('page', $page->slug)); ?>"><?php echo e($page->title); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          
        </ul>
      </div>
  
      <!-- Column 4: Newsletter -->
      <div>
        <h4 class="font-semibold mb-4">Newsletter</h4>
        <p class="text-sm text-slate-600 dark:text-slate-400 mb-4">
          Subscribe to get the latest updates and offers.
        </p>
        <form class="flex flex-col sm:flex-row gap-2">
          <input type="email" placeholder="Your email" class="w-full rounded-md border border-slate-300 dark:border-slate-700 bg-white dark:bg-slate-900 px-3 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-slate-400 dark:focus:ring-slate-600">
          <button type="submit" class="rounded-md bg-slate-900 text-white dark:bg-white dark:text-slate-900 px-4 py-2 text-sm font-semibold hover:opacity-90">Subscribe</button>
        </form>
      </div>
    </div>
  
    <!-- Bottom bar -->
    <div class="border-t border-slate-200 dark:border-slate-800">
      <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8 py-4 flex flex-col sm:flex-row items-center justify-between text-sm text-slate-600 dark:text-slate-400">
        <p>Copyright ©
            <script>
                document.write(new Date().getFullYear())
            </script>

            <?php if($settings): ?>
                <?php echo e($settings->site_title); ?>

            <?php endif; ?> All rights reserved.</p>
        <p>Made with ❤️ </p>
      </div>
    </div>
  </footer>
  <?php /**PATH /home/dealqmki/blogzcenter.com/resources/views/user/includes/footer.blade.php ENDPATH**/ ?>