
<?php $__env->startSection('meta-content'); ?>
 <?php
    $settings = \App\Models\GeneralSetting::find(1);
    ?>
<title><?php if($settings): ?><?php echo e($settings->site_title); ?><?php endif; ?></title>
<meta name="description" content="<?php if($settings): ?><?php echo e($settings->meta_description); ?><?php endif; ?>">
<meta name="title" content="<?php if($settings): ?><?php echo e($settings->meta_title); ?><?php endif; ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-styles'); ?>
   
<style>
      .hero-banner {
      background: linear-gradient(120deg, #fff 0%, #f0f0f0 100%);
      padding: 40px 20px;
      border-radius: 20px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.08);
    }

    .coupon-card {
      border-radius: 16px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.08);
      background: white;
      padding: 20px;
      transition: all 0.3s ease;
    }

    .coupon-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 8px 20px rgba(0,0,0,0.1);
    }

    .coupon-code {
      background: #e0f7fa;
      color: #00796b;
      font-weight: bold;
      padding: 5px 12px;
      border-radius: 10px;
      display: inline-block;
    }

    .brand-sidebar {
      border-radius: 16px;
      background: white;
      padding: 20px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.08);
    }

    .brand-logo {
      width: 120px;
      object-fit: contain;
    }
  </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb-area -->
    <div class="breadcrumb-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-content">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('index')); ?>">Home</a></li>
                                <li class="breadcrumb-item" aria-current="page"><a href="javascript:;">Blogs</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?php echo e($store->slug); ?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb-area-end -->
    <div class="container my-5">
        <!-- Hero Banner -->
        <div class="hero-banner text-center mb-5">
          <img src="<?php echo e(asset('admin-assets/images/stores')); ?>/<?php echo e($store->feature_image); ?>" alt="<?php echo e($store->name); ?> Logo" class="brand-logo mb-3">
          <h1 class="fw-bold"><?php echo e($store->name); ?></h1>
          <p class="text-muted">Save big on your next <?php echo e($store->name); ?> purchase with these exclusive deals and offers!</p>
        </div>
    
        <div class="row">
          <!-- Main Coupons Section -->
          <div class="col-lg-8 mb-4">
            <div class="row g-4">
            <?php $__currentLoopData = $coupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <div class="col-md-6">
                <div class="coupon-card">
                  <h5 class="fw-bold"><?php echo e($row->title); ?></h5>
                  <p class="text-muted"><?php echo e($row->description); ?></p>
                 <a href="<?php echo e($row->url); ?>" target="_blank" id="btn"
                    data-title="<?php echo e($row->title); ?>" data-des="<?php echo e($row->description); ?>"
                    data-code="<?php echo e($row->code); ?>" data-url="<?php echo e($row->url); ?>"
                    data-coupon_id="<?php echo e($row->id); ?>"
                    data-img="<?php echo e(asset('admin-assets/images/stores')); ?>/<?php echo e($store->feature_image); ?>" data-clipboard-action="copy"
                    data-clipboard-target="#code_text">
                    <span class="coupon-code code_text">
                        <?php if($row->code): ?><?php echo e($row->code); ?> <?php else: ?> Get Deal <?php endif; ?>
                    </span>
                 </a>
                </div>
              </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
          </div>
    
          <!-- Sidebar -->
          <div class="col-lg-4">
            <div class="brand-sidebar">
              <h5 class="fw-bold mb-3">About <?php echo e($store->name); ?></h5>
              <p class="text-muted"><?php echo e($store->description); ?></p>
              
            </div>
          </div>
        </div>
      </div>
    
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-scripts'); ?>
    <script src="<?php echo e(asset('user-assets/js/clipboard.min.js')); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset('user-assets/js/custom.js')); ?>" type="text/javascript"></script>
    <script>
        var btn = document.getElementById('btn');
        var clipboard = new ClipboardJS(btn);

        clipboard.on('success', function(e) {
            console.info('Action:', e.action);
            console.info('Text:', e.text);
            console.info('Trigger:', e.trigger);
        });

        clipboard.on('error', function(e) {
            console.info('Action:', e.action);
            console.info('Text:', e.text);
            console.info('Trigger:', e.trigger);
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\realtimebrief\resources\views/user/pages/store-profile.blade.php ENDPATH**/ ?>