<div class="sticky top-0 z-50">
    <div class="w-full  bg-slate-100 dark:bg-slate-900 border-b border-slate-200 dark:border-slate-800">
      <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8 h-10 flex items-center justify-between">
        <!-- Social icons -->
        <div class="flex items-center gap-3">
          <?php
              $social_links = \App\Models\SocialMedia::get();
            ?>
            
            <?php $__currentLoopData = $social_links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <a href="<?php echo e($link->url); ?>" class="p-1 rounded hover:bg-slate-200 dark:hover:bg-slate-800" aria-label="<?php echo e($link->title); ?>" target="_blank">
                <i class="fab fa-<?php echo e(strtolower($link->title)); ?> text-lg"></i>
              </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

          
        </div>

        <!-- Extra topbar tabs -->
        <nav aria-label="Topbar" class="hidden md:flex items-center gap-6 text-sm">
          <a href="#" class="hover:text-white dark:hover:text-white">About</a>
          <a href="#" class="hover:text-white dark:hover:text-white">Careers</a>
          <a href="#" class="hover:text-white dark:hover:text-white">Pricing</a>
          <a href="#" class="hover:text-white dark:hover:text-white">Contact</a>
        </nav>

        <!-- Topbar overflow for mobile -->
        <div class="md:hidden text-xs text-white dark:text-slate-400">Welcome!</div>
      </div>
    </div>

    <!-- Main Header -->
    <header class="bg-white/90 dark:bg-slate-950/90 backdrop-blur border-b border-slate-200 dark:border-slate-800">
      <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8 h-16 grid grid-cols-3 items-center">
        <!-- Left: Desktop Menu / Mobile Hamburger -->
        <div class="flex items-center">
          <!-- Mobile: Hamburger -->
          <button id="openDrawerBtn"
                  class="md:hidden inline-flex items-center justify-center p-2 rounded-md hover:bg-slate-100 dark:hover:bg-slate-800"
                  aria-label="Open main menu" aria-controls="mobileDrawer" aria-expanded="false">
            <!-- Hamburger -->
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 6h16M4 12h16M4 18h16" />
            </svg>
          </button>

          <!-- Desktop: Left Menu -->
          <nav class="hidden md:flex items-center gap-4" aria-label="Primary">
            <?php
                    $categories = \App\Models\Category::select('id', 'slug', 'name')
                        ->limit(5)
                        ->get();
                ?>
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e(route('blogs.category', $row->slug)); ?>" class="text-sm max-w-[130px] truncate hover:text-slate-900 dark:hover:text-white"><?php echo e($row->name); ?></a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </nav>
        </div>

        <!-- Center: Logo -->
        <div class="flex items-center justify-center py-1">
            <a href="<?php echo e(route('index')); ?>" class="inline-flex items-center gap-2 font-semibold text-lg">
              <img src="<?php if($settings): ?><?php echo e(asset('admin-assets/images/logos')); ?>/<?php echo e($settings->footer_logo); ?><?php endif; ?>" alt="Logo" class="h-10 object-contain" />
            </a>
        </div>
          

        <!-- Right: Search + Theme Toggle -->
        <div class="flex items-center justify-end gap-2">
          <!-- Search (hidden on xs) -->
          <form role="search" class="hidden sm:flex items-center">
            <label for="siteSearch" class="sr-only">Search</label>
            <div class="relative">
              <input id="siteSearch" name="q" type="search" placeholder="Search..."
                     class="w-48 lg:w-64 rounded-md border border-slate-300 dark:border-slate-700 bg-white dark:bg-slate-900 px-3 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-slate-400 dark:focus:ring-slate-600 search-input" />
              <span class="pointer-events-none absolute inset-y-0 right-2 flex items-center">
                <!-- Search icon -->
                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 opacity-60" viewBox="0 0 24 24" fill="none" stroke="currentColor" aria-hidden="true">
                  <circle cx="11" cy="11" r="7" stroke-width="1.5"></circle>
                  <path d="m20 20-3.5-3.5" stroke-width="1.5"></path>
                </svg>
              </span>
            </div>
          </form>
           <div class="autocomplete" style="display:none"></div>

          <!-- Mobile search icon -->
          <button id="openSearchBtn" class="sm:hidden inline-flex items-center justify-center p-2 rounded-md hover:bg-slate-100 dark:hover:bg-slate-800" aria-label="Open search">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" aria-hidden="true">
              <circle cx="11" cy="11" r="7" stroke-width="1.5"></circle>
              <path d="m20 20-3.5-3.5" stroke-width="1.5"></path>
            </svg>
          </button>

          
        </div>
      </div>
    </header>
  </div>

  <!-- Mobile Drawer -->
  <div id="drawerOverlay" class="fixed inset-0 bg-black/40 opacity-0 pointer-events-none z-40 drawer-transition"></div>
  <aside id="mobileDrawer"
         class="fixed top-0 left-0 h-full w-72 max-w-[80vw] bg-white dark:bg-slate-950 shadow-xl -translate-x-full drawer-transition z-50"
         role="dialog" aria-modal="true" aria-labelledby="mobileDrawerTitle">
    <div class="flex items-center justify-between px-4 h-16 border-b border-slate-200 dark:border-slate-800">
      <h2 id="mobileDrawerTitle" class="font-semibold">Menu</h2>
      <button id="closeDrawerBtn" class="p-2 rounded-md hover:bg-slate-100 dark:hover:bg-slate-800" aria-label="Close menu">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M6 18 18 6M6 6l12 12"/></svg>
      </button>
    </div>
    <nav class="px-4 py-4 space-y-1" aria-label="Mobile">
         <?php
                    $categories = \App\Models\Category::select('id', 'slug', 'name')
                        ->limit(5)
                        ->get();
                ?>
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <a href="<?php echo e(route('blogs.category', $row->slug)); ?>" class="block rounded-md px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800"><?php echo e($row->name); ?></a>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      <hr class="my-3 border-slate-200 dark:border-slate-800">
      <div class="text-xs uppercase tracking-wider text-slate-500 dark:text-slate-400 px-3">Topbar Links</div>
      <a href="#" class="block rounded-md px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800">About</a>
      <a href="#" class="block rounded-md px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800">Careers</a>
      <a href="#" class="block rounded-md px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800">Pricing</a>
      <a href="#" class="block rounded-md px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800">Contact</a>
    </nav>
  </aside>

  <!-- Mobile Search Sheet -->
  <div id="searchSheet" class="fixed inset-x-0 top-0 z-50 translate-y-[-100%] drawer-transition">
    <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
      <div class="mt-2 rounded-xl bg-white dark:bg-slate-950 border border-slate-200 dark:border-slate-800 shadow">
        <div class="flex items-center gap-2 p-3">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-60" viewBox="0 0 24 24" fill="none" stroke="currentColor"><circle cx="11" cy="11" r="7" stroke-width="1.5"></circle><path d="m20 20-3.5-3.5" stroke-width="1.5"></path></svg>
          <input type="search" placeholder="Search..." class="flex-1 bg-transparent outline-none text-base search-input" />
          <button id="closeSearchBtn" class="p-2 rounded-md hover:bg-slate-100 dark:hover:bg-slate-800" aria-label="Close search">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M6 18 18 6M6 6l12 12"/></svg>
          </button>
        </div>
      </div>
      <div class="autocomplete" style="display:none"></div>
    </div>
  </div>
  <script>
    // Theme toggle
    const themeToggleBtn = document.getElementById('themeToggle');
    themeToggleBtn?.addEventListener('click', () => {
      const isDark = document.documentElement.classList.toggle('dark');
      localStorage.setItem('theme', isDark ? 'dark' : 'light');
    });

    // Drawer logic
    const openDrawerBtn = document.getElementById('openDrawerBtn');
    const closeDrawerBtn = document.getElementById('closeDrawerBtn');
    const drawer = document.getElementById('mobileDrawer');
    const overlay = document.getElementById('drawerOverlay');

    function openDrawer() {
      drawer.style.transform = 'translateX(0)';
      overlay.style.opacity = '1';
      overlay.style.pointerEvents = 'auto';
      openDrawerBtn?.setAttribute('aria-expanded', 'true');
      document.body.style.overflow = 'hidden';
    }
    function closeDrawer() {
      drawer.style.transform = 'translateX(-100%)';
      overlay.style.opacity = '0';
      overlay.style.pointerEvents = 'none';
      openDrawerBtn?.setAttribute('aria-expanded', 'false');
      document.body.style.overflow = '';
    }
    openDrawerBtn?.addEventListener('click', openDrawer);
    closeDrawerBtn?.addEventListener('click', closeDrawer);
    overlay?.addEventListener('click', closeDrawer);
    window.addEventListener('keydown', (e) => { if (e.key === 'Escape') { closeDrawer(); closeSearch(); } });

    // Mobile search sheet
    const openSearchBtn = document.getElementById('openSearchBtn');
    const closeSearchBtn = document.getElementById('closeSearchBtn');
    const searchSheet = document.getElementById('searchSheet');

    function openSearch() { searchSheet.style.transform = 'translateY(0)'; }
    function closeSearch() { searchSheet.style.transform = 'translateY(-100%)'; }

    openSearchBtn?.addEventListener('click', openSearch);
    closeSearchBtn?.addEventListener('click', closeSearch);
  </script><?php /**PATH /home/dealqmki/blogzcenter.com/resources/views/user/includes/header.blade.php ENDPATH**/ ?>