
<?php $__env->startSection('custom-styles'); ?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/izitoast/dist/css/iziToast.min.css">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta-content'); ?>
<title><?php echo e($blog->title); ?></title>
<meta name="description" content="<?php echo e($blog->meta_description); ?>">
<meta name="title" content="<?php echo e($blog->meta_title); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- breadcrumb-area -->
  <!-- breadcrumb-area -->
  <nav class="bg-gradient-to-r from-[#FF2A26] to-white dark:from-[#FF2A26] dark:to-slate-600 py-3" aria-label="Breadcrumb">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <ol class="flex flex-wrap items-center gap-2 text-sm text-slate-700 dark:text-slate-200">

      <!-- Home -->
      <li class="flex items-center gap-1">
        <a href="<?php echo e(route('index')); ?>" class="hover:text-indigo-600 dark:hover:text-white flex items-center gap-1">
          <svg class="h-4 w-4 shrink-0" fill="currentColor" viewBox="0 0 20 20">
            <path d="M10.707 1.707a1 1 0 00-1.414 0L2 9h3v6a1 1 0 001 1h8a1 1 0 001-1V9h3l-7.293-7.293z" />
          </svg>
          <span class="whitespace-nowrap">Home</span>
        </a>
      </li>

      <!-- Divider -->
      <li class="text-slate-400 dark:text-slate-600">
        <svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
          <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L11.586 9 7.293 4.707a1 1 0 111.414-1.414l5 5a1 1 0 010 1.414l-5 5a1 1 0 01-1.414 0z" clip-rule="evenodd" />
        </svg>
      </li>

      <!-- Stores -->
      <li class="flex items-center">
        <a href="javascript:;" class="hover:text-indigo-600 dark:hover:text-white whitespace-nowrap"><?php echo e($blog->category->name); ?></a>
      </li>

      <!-- Divider -->
      <li class="text-slate-400 dark:text-slate-600">
        <svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
          <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L11.586 9 7.293 4.707a1 1 0 111.414-1.414l5 5a1 1 0 010 1.414l-5 5a1 1 0 01-1.414 0z" clip-rule="evenodd" />
        </svg>
      </li>

      <!-- Current Store -->
      <li class="flex items-center">
        <a href="javascript:;" class="hover:text-indigo-600 dark:hover:text-white whitespace-nowrap"><?php echo e($blog->sub_category->name); ?></a>
      </li>
      
       <!-- Divider -->
      <li class="text-slate-400 dark:text-slate-600">
        <svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
          <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L11.586 9 7.293 4.707a1 1 0 111.414-1.414l5 5a1 1 0 010 1.414l-5 5a1 1 0 01-1.414 0z" clip-rule="evenodd" />
        </svg>
      </li>

      <!-- Current Store -->
      <li class="flex items-center">
        <a href="javascript:;" class="hover:text-indigo-600 dark:hover:text-white whitespace-nowrap"><?php echo e($blog->slug); ?></a>
      </li>

    </ol>
  </div>
</nav>

  
    
  <section class="bg-white dark:bg-slate-950 py-10">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
      <div class="grid grid-cols-1 lg:grid-cols-12 gap-10">
  
        <!-- 📝 Left Column - Blog Detail (8 cols) -->
        <div class="lg:col-span-8">
            <!-- Blog Title -->
            <h1 class="text-3xl md:text-4xl font-bold text-slate-900 dark:text-white mb-4">
                <?php echo e($blog->title); ?>

            </h1>
        
            <!-- Meta Info -->
            <div class="text-sm text-slate-600 dark:text-slate-400 mb-6 flex items-center gap-4">
                <span>By Admin</span>
                <span>• <?php echo e($blog->created_at->format('d M, Y')); ?></span>
                <span>• <?php echo e($blog->category->name); ?></span>
            </div>
        
            <!-- Featured Image -->
            <?php if($blog->feature_image): ?>
            <img src="<?php echo e(asset('admin-assets/images/blogs')); ?>/<?php echo e($blog->feature_image); ?>" alt="<?php echo e($blog->title); ?>" class="rounded-lg mb-8 w-full object-cover max-h-[480px]">
            <?php endif; ?>
        
            <!-- Blog Content -->
            <div class="prose prose-lg max-w-none dark:prose-invert prose-headings:scroll-mt-16 prose-a:text-indigo-600 prose-a:no-underline hover:prose-a:underline">
                <?php echo $blog->description; ?>

            </div>
    
        </div>
        <!-- 📚 Right Column - Sidebar (4 cols) -->
      <div class="lg:col-span-4">
        <div class="sticky top-28">
            <div class="mb-8">
                <h4 class="font-semibold mb-3">Categories</h4>
                <ul class="space-y-3">
        
                  <!-- Card -->
                  <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <li>
                    <a href="<?php echo e(route('blogs.category',$row->slug)); ?>"
                      class="group relative block overflow-hidden rounded-lg shadow hover:shadow-lg focus:outline-none focus:ring-2 focus:ring-slate-400 dark:focus:ring-slate-600">
                      <!-- Background image -->
                      <div class="absolute inset-0 bg-center bg-cover transition-transform duration-500 group-hover:scale-105"
                          style="background-image:url('<?php echo e(asset('admin-assets/images/categories')); ?>/<?php echo e($row->feature_image); ?>');"></div>
        
                      <!-- Dark gradient overlay -->
                      <div class="absolute inset-0 bg-gradient-to-r from-black/60 via-black/30 to-black/10"></div>
        
                      <!-- Content -->
                      <div class="relative p-4 flex items-center justify-between">
                        <div>
                          <span class="text-white font-semibold"><?php echo e($row->name); ?></span>
                          <div class="text-white/80 text-xs"><?php echo e($row->blogs_count); ?> articles</div>
                        </div>
                        <span class="inline-flex items-center rounded-full bg-white/90 text-slate-900 text-xs px-2 py-1 group-hover:translate-x-0.5 transition">
                          Explore
                          <svg xmlns="http://www.w3.org/2000/svg" class="ml-1 h-3.5 w-3.5" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                            <path d="M9 18l6-6-6-6" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                          </svg>
                        </span>
                      </div>
                    </a>
                  </li>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
              </div>
        </div>
      </div>
      </div>
  
    </div>
  </section>
  

<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/izitoast/dist/js/iziToast.min.js"></script>
<script>
   $("#comment_form_btn").click(function(e) {
       e.preventDefault();
       let form = $('#comment_form')[0];
       let data = new FormData(form);
   
       $.ajax({
           url: "<?php echo e(route('comment.store')); ?>",
           type: "POST",
           data: data,
           dataType: "JSON",
           processData: false,
           contentType: false,
   
           success: function(response) {
   
               if (response.errors) {
                   var errorMsg = '';
                   $.each(response.errors, function(field, errors) {
                       $.each(errors, function(index, error) {
                           errorMsg += error + '<br>';
                       });
                   });
                   iziToast.error({
                       message: 'Comment Failed',
                       position: 'topRight'
                   });
   
               } else {
                   iziToast.success({
                       message: response.success,
                       position: 'topRight'
   
                   });
   
                   $("#comments-section").load(location.href + " #comments-section");
   
               }
   
           },
           error: function(xhr, status, error) {
   
               iziToast.error({
                   message: 'An error occurred: ' + error,
                   position: 'topRight'
               });
           }
   
       });
   
   });
   
   $(document).on('click', '.reply_btn', function() {
       var comment_id = $(this).data('comment_id');
       var comment_id = $(this).data('user_id');
       // var html = ``;
       $(this).css('display', 'none');
       $(this).closest('.comments-text').find('.reply-section').css('display', 'block');
       $(this).closest('.comments-text').find('.cancelli').css('display', 'block');
   
   });
   
   $(document).on('click', '.cancel_btn', function() {
       var comment_id = $(this).data('comment_id');
       var comment_id = $(this).data('user_id');
       // var html = ``;
       $(this).closest('.comments-text').find('.cancelli').css('display', 'none');
       $(this).closest('.comments-text').find('.reply-section').css('display', 'none');
       $(this).closest('.comments-text').find('.reply_btn').css('display', 'block');
   
   });
   
   $(".reply_form_btn").click(function(e) {
       e.preventDefault();
       let form = $(this).closest('.comments-text').find('.reply_form')[0];
       let data = new FormData(form);
   
       $.ajax({
           url: "<?php echo e(route('reply.store')); ?>",
           type: "POST",
           data: data,
           dataType: "JSON",
           processData: false,
           contentType: false,
   
           success: function(response) {
   
               if (response.errors) {
                   var errorMsg = '';
                   $.each(response.errors, function(field, errors) {
                       $.each(errors, function(index, error) {
                           errorMsg += error + '<br>';
                       });
                   });
                   iziToast.error({
                       message: 'Comment Failed',
                       position: 'topRight'
                   });
   
               } else {
                   iziToast.success({
                       message: response.success,
                       position: 'topRight'
   
                   });
   
                   $("#comments-section").load(location.href + " #comments-section");
   
               }
   
           },
           error: function(xhr, status, error) {
   
               iziToast.error({
                   message: 'An error occurred: ' + error,
                   position: 'topRight'
               });
           }
   
       });
   
   });
   
   $(document).on('click', '#like_comment_btn', function(e) {
       e.preventDefault();
       // let form = $(this).closest('.comments-text').find('.reply_form')[0];
       // let data = new FormData(form);
       var comment_id = $(this).data('comment_id');
       console.log(comment_id);
       $.ajax({
           url: "<?php echo e(route('comment.like')); ?>",
           type: "GET",
           data: {
               comment_id: comment_id
           },
           dataType: "JSON",
   
           success: function(response) {
   
               if (response.errors) {
                   var errorMsg = '';
                   $.each(response.errors, function(field, errors) {
                       $.each(errors, function(index, error) {
                           errorMsg += error + '<br>';
                       });
                   });
                   iziToast.error({
                       message: response.error,
                       position: 'topRight'
                   });
   
               } else {
                   iziToast.success({
                       message: response.success,
                       position: 'topRight'
   
                   });
   
                   $("#comments-section").load(location.href + " #comments-section");
   
               }
   
           },
           error: function(xhr, status, error) {
   
               iziToast.error({
                   message: 'An error occurred: ' + error,
                   position: 'topRight'
               });
           }
   
       });
   
   });
   
   $(document).on('click', '#like_reply_btn', function(e) {
       e.preventDefault();
       // let form = $(this).closest('.comments-text').find('.reply_form')[0];
       // let data = new FormData(form);
       var reply_id = $(this).data('reply_id');
       console.log(reply_id);
       $.ajax({
           url: "<?php echo e(route('reply.like')); ?>",
           type: "GET",
           data: {
               reply_id: reply_id
           },
           dataType: "JSON",
   
           success: function(response) {
   
               if (response.errors) {
                   var errorMsg = '';
                   $.each(response.errors, function(field, errors) {
                       $.each(errors, function(index, error) {
                           errorMsg += error + '<br>';
                       });
                   });
                   iziToast.error({
                       message: response.error,
                       position: 'topRight'
                   });
   
               } else {
                   iziToast.success({
                       message: response.success,
                       position: 'topRight'
   
                   });
   
                   $("#comments-section").load(location.href + " #comments-section");
   
               }
   
           },
           error: function(xhr, status, error) {
   
               iziToast.error({
                   message: 'An error occurred: ' + error,
                   position: 'topRight'
               });
           }
   
       });
   
   });
   
   $(document).on('click', '#dlt_comment_btn', function(e) {
       e.preventDefault();
       // let form = $(this).closest('.comments-text').find('.reply_form')[0];
       // let data = new FormData(form);
       var comment_id = $(this).data('comment_id');
       console.log(comment_id);
       $.ajax({
           url: "<?php echo e(route('comment.delete')); ?>",
           type: "GET",
           data: {
               comment_id: comment_id
           },
           dataType: "JSON",
   
           success: function(response) {
   
               if (response.errors) {
                   var errorMsg = '';
                   $.each(response.errors, function(field, errors) {
                       $.each(errors, function(index, error) {
                           errorMsg += error + '<br>';
                       });
                   });
                   iziToast.error({
                       message: response.error,
                       position: 'topRight'
                   });
   
               } else {
                   iziToast.success({
                       message: response.success,
                       position: 'topRight'
   
                   });
   
                   $("#comments-section").load(location.href + " #comments-section");
   
               }
   
           },
           error: function(xhr, status, error) {
   
               iziToast.error({
                   message: 'An error occurred: ' + error,
                   position: 'topRight'
               });
           }
   
       });
   
   });
   
   $(document).on('click', '#dlt_reply_btn', function(e) {
       e.preventDefault();
       // let form = $(this).closest('.comments-text').find('.reply_form')[0];
       // let data = new FormData(form);
       var reply_id = $(this).data('reply_id');
   
       $.ajax({
           url: "<?php echo e(route('reply.delete')); ?>",
           type: "GET",
           data: {
               reply_id: reply_id
           },
           dataType: "JSON",
   
           success: function(response) {
   
               if (response.errors) {
                   var errorMsg = '';
                   $.each(response.errors, function(field, errors) {
                       $.each(errors, function(index, error) {
                           errorMsg += error + '<br>';
                       });
                   });
                   iziToast.error({
                       message: response.error,
                       position: 'topRight'
                   });
   
               } else {
                   iziToast.success({
                       message: response.success,
                       position: 'topRight'
   
                   });
   
                   $("#comments-section").load(location.href + " #comments-section");
   
               }
   
           },
           error: function(xhr, status, error) {
   
               iziToast.error({
                   message: 'An error occurred: ' + error,
                   position: 'topRight'
               });
           }
   
       });
   
   });
   
   $(document).on('click', '#save_btn', function(e) {
       e.preventDefault();
   
       var blog_id = $(this).data('id');
       console.log(blog_id);
       $.ajax({
           url: "<?php echo e(route('blog.save')); ?>",
           type: "GET",
           data: {
               blog_id: blog_id
           },
           dataType: "JSON",
   
           success: function(response) {
   
               if (response.errors) {
                   var errorMsg = '';
                   $.each(response.errors, function(field, errors) {
                       $.each(errors, function(index, error) {
                           errorMsg += error + '<br>';
                       });
                   });
                   iziToast.error({
                       message: response.error,
                       position: 'topRight'
                   });
   
               } else {
                   iziToast.success({
                       message: response.success,
                       position: 'topRight'
   
                   });
   
                   $("#save-section").load(location.href + " #save-section");
   
               }
   
           },
           error: function(xhr, status, error) {
   
               iziToast.error({
                   message: 'An error occurred: ' + error,
                   position: 'topRight'
               });
           }
   
       });
   
   });
   
   
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dealqmki/brieflylive.com/resources/views/user/pages/blog-details.blade.php ENDPATH**/ ?>