

<?php $__env->startSection('content'); ?>
    <div class="row clearfix">
        <div class="col-lg-12">
            <div class="card">
                <div class="header">
                    <h2><strong>All</strong> Users </h2>
                    <ul class="header-dropdown">
                        <li class="dropdown">
                            <a href="<?php echo e(route('users.create')); ?>" class="btn btn-primary btn-sm float-right">Add
                                User</a>
                        </li>
                    </ul>
                </div>
                <div class="mt-2">
                    <?php echo $__env->make('admin.layouts.partials.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover js-basic-example dataTable">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Role</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tfoot>
                                <tr>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Role</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </tfoot>
                            <tbody>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($user->name); ?></td>
                                        <td><?php echo e($user->email); ?></td>
                                        <td><?php echo e($user->role); ?></td>
                                        <td><?php if($user->status == 'Active'): ?> <span class="badge badge-success">Active</span> <?php else: ?> <span class="badge badge-danger">De-Active</span> <?php endif; ?></td>
                                        <td>
                                            <a class="btn btn-info btn-sm" href="<?php echo e(route('change.password', $user->id)); ?>">Change Password</a>
                                            <a class="btn btn-primary btn-sm" href="<?php echo e(route('users.edit', $user->id)); ?>">Edit</a>
                                        
                                            <?php echo Form::open(['method' => 'DELETE','route' => ['users.destroy', $user->id],'style'=>'display:inline']); ?>

                                            <?php echo Form::submit('Delete', ['class' => 'btn btn-danger btn-sm']); ?>

                                            <?php echo Form::close(); ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <div class="d-flex">
                            <?php echo $users->links('pagination::bootstrap-4'); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom-scripts'); ?>
   
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dealqmki/blogzcenter.com/resources/views/admin/pages/users/index.blade.php ENDPATH**/ ?>