
<?php $__env->startSection('content'); ?>
<!-- Breaking News Ticker -->
<section class="bg-[#0F2C56] border-y border-slate-200 dark:border-slate-800">
  <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
    <div class="flex flex-wrap items-center gap-3 py-2">

      <!-- Label + Clock -->
      <div class="flex items-center gap-3">
        <div class="flex items-center gap-2 px-2.5 py-1 rounded-md bg-red-600 text-white text-xs font-semibold">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
              d="M19 7l-7 4m0 0l-7 4m7-4v8M5 11V7a2 2 0 012-2h3.28a2 2 0 011.789 1.106L13 7" />
          </svg>
          <span>Breaking</span>
        </div>
        <div class="text-xs font-semibold text-slate-200 dark:text-slate-300" id="localClock">--:-- --</div>
      </div>

      <!-- Ticker -->
      <div class="flex-1 min-w-0 overflow-hidden">
        <div class="swiper breakingTicker" role="region" aria-live="polite" aria-label="Breaking news headlines">
          <div class="swiper-wrapper">

            <!-- Slide -->
            <div class="swiper-slide !w-auto pr-4 whitespace-nowrap">
              <a href="#" class="inline-flex items-center gap-2 text-sm text-white hover:underline">
                <span class="inline-flex items-center gap-1 rounded-full px-2 py-0.5 text-xs bg-white text-black">
                  Tech
                </span>
                Apple unveils next‑gen M‑series chips
                <time class="text-xs text-slate-300">• 5m ago</time>
              </a>
            </div>

            <div class="swiper-slide !w-auto pr-4 whitespace-nowrap">
              <a href="#" class="inline-flex items-center gap-2 text-sm text-white hover:underline">
                <span class="inline-flex items-center gap-1 rounded-full px-2 py-0.5 text-xs bg-white text-black">
                  Business
                </span>
                Startups raise record seed rounds in Q3
                <time class="text-xs text-slate-300">• 12m ago</time>
              </a>
            </div>

            <div class="swiper-slide !w-auto pr-4 whitespace-nowrap">
              <a href="#" class="inline-flex items-center gap-2 text-sm text-white hover:underline">
                <span class="inline-flex items-center gap-1 rounded-full px-2 py-0.5 text-xs bg-white text-black">
                  Design
                </span>
                Minimalist UI patterns dominate 2025
                <time class="text-xs text-slate-300">• 24m ago</time>
              </a>
            </div>

            <div class="swiper-slide !w-auto pr-4 whitespace-nowrap">
              <a href="#" class="inline-flex items-center gap-2 text-sm text-white hover:underline">
                <span class="inline-flex items-center gap-1 rounded-full px-2 py-0.5 text-xs bg-white text-black">
                  SEO
                </span>
                Search update prioritizes expertise
                <time class="text-xs text-slate-300">• 39m ago</time>
              </a>
            </div>

          </div>
        </div>
      </div>

      <!-- Pause Button -->
      <button id="tickerToggle"
        class="hidden sm:inline-flex items-center text-xs px-2 py-1 rounded-md border border-slate-300 dark:border-slate-700 text-white hover:bg-slate-800"
        aria-pressed="false" aria-label="Pause ticker">
        Pause
      </button>
    </div>
  </div>
</section>
<section class="py-12 bg-white dark:bg-slate-950">
  <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
    <h2 class="text-2xl md:text-3xl font-bold mb-8">Latest Headlines</h2>

    <!-- Top Grid (3 columns) -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 mb-10">

      <!-- Big Lead Story -->
      <?php
          $popularblog = $popularblogs->shift();
      ?>
      <?php if($popularblog): ?>
      <article class="lg:col-span-2 relative group rounded-lg overflow-hidden shadow hover:shadow-xl transition"
               data-aos="fade-right">
        <img src="<?php echo e(asset('admin-assets/images/blogs')); ?>/<?php echo e($popularblog->feature_image); ?>"
             class="w-full h-80 object-cover group-hover:scale-105 transition-transform duration-500">
        <div class="absolute inset-0 bg-gradient-to-t from-black/80 via-black/50 to-transparent p-6 flex flex-col justify-end">
          <span class="text-xs uppercase text-white/80"><?php echo e($popularblog->category->name); ?></span>
          <h3 class="mt-2 text-3xl font-bold text-white">
            <a href="<?php echo e(route('blog.details',$popularblog->slug)); ?>" class="hover:underline"><?php echo e($popularblog->title); ?></a>
          </h3>
          
        </div>
      </article>
      <?php endif; ?>
      <!-- Side Vertical List -->
      <div class="flex flex-col gap-6" data-aos="fade-left">
        <?php $__currentLoopData = $popularblogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <article class="flex gap-4 group">
          <img src="<?php echo e(asset('admin-assets/images/blogs')); ?>/<?php echo e($row->feature_image); ?>" class="w-28 h-24 object-cover rounded group-hover:scale-105 transition">
          <div>
            <span class="text-xs uppercase text-slate-500"><?php echo e($row->category->name); ?></span>
            <h4 class="font-semibold text-base leading-tight mt-1">
              <a href="<?php echo e(route('blog.details',$row->slug)); ?>" class="hover:underline"><?php echo e($row->title); ?></a>
            </h4>
          </div>
        </article>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
    </div>

    <!-- Lower Grid (8 articles in masonry-like grid) -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8">
      <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <article class="group" data-aos="fade-up">
        <img src="<?php echo e(asset('admin-assets/images/blogs')); ?>/<?php echo e($row->feature_image); ?>" class="w-full h-40 object-cover rounded group-hover:scale-105 transition">
        <div class="mt-3">
          <span class="text-xs uppercase text-slate-500"><?php echo e($row->category->name); ?></span>
          <h4 class="mt-1 text-base font-semibold">
            <a href="<?php echo e(route('blog.details', $row->slug)); ?>" class="hover:underline"><?php echo e($row->title); ?></a>
          </h4>
        </div>
      </article>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </div>
  </div>
</section>
<section class="py-12 bg-white dark:bg-slate-950">
  <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
    <h2 class="text-2xl md:text-3xl font-bold mb-8 text-white">Spotlight Stories</h2>

    <div class="swiper articleSwiper relative">
      <div class="swiper-wrapper">

        <!-- Slide -->
        <?php $__currentLoopData = $popblogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="swiper-slide group w-[280px] md:w-[360px] lg:w-[400px]">
          <article class="relative rounded-2xl overflow-hidden shadow-lg">
            <!-- Image -->
            <img src="<?php echo e(asset('admin-assets/images/blogs')); ?>/<?php echo e($row->feature_image); ?>" alt="AI Devices"
                 class="h-64 w-full object-cover transition-transform duration-700 ease-out group-hover:scale-105" />
            <!-- Overlay -->
            <div class="absolute inset-0 bg-gradient-to-t from-black/85 via-black/30 to-transparent"></div>

            <!-- Content -->
            <div class="absolute inset-x-0 bottom-0 p-5">
              <div class="mb-2 inline-flex items-center gap-2">
                <span class="text-[11px] uppercase tracking-wide rounded-full bg-white/90 text-slate-900 px-2 py-0.5 dark:bg-slate-200"><?php echo e($row->category->name); ?></span>
                <span class="text-xs text-white/80"><?php echo e($row->created_at->format('d M, Y')); ?></span>
              </div>
              <h3 class="text-white font-bold text-lg leading-snug">
                <?php echo e($row->title); ?>

              </h3>
              <a href="<?php echo e(route('blog.details', $row->slug)); ?>"
                 class="mt-2 inline-block text-sm font-semibold text-white/90 group-hover:text-white transition">
                Read More →
              </a>
            </div>
          </article>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

      </div>

      <!-- Controls -->
      <div class="swiper-button-next !text-slate-700 dark:!text-slate-200"></div>
      <div class="swiper-button-prev !text-slate-700 dark:!text-slate-200"></div>
      <div class="swiper-pagination !bottom-[-30px]"></div>
    </div>
  </div>
</section>
<section class="py-12 bg-slate-50 dark:bg-slate-900">
  <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8 grid grid-cols-1 lg:grid-cols-3 gap-8">

    <!-- Latest Posts -->
    <div class="lg:col-span-2">
      <h2 class="text-2xl md:text-3xl font-bold mb-8">Latest Posts</h2>
      <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-8">

        <?php $__currentLoopData = $topblogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <article class="group rounded-lg overflow-hidden shadow hover:shadow-xl transition relative">
          <div class="overflow-hidden">
            <img src="<?php echo e(asset('admin-assets/images/blogs')); ?>/<?php echo e($row->feature_image); ?>"
                 class="w-full h-48 object-cover group-hover:scale-105 transition-transform duration-500">
          </div>
          <div class="p-4">
            <span class="text-xs uppercase tracking-wide text-white"><?php echo e($row->category->name); ?></span>
            <h3 class="mt-2 text-lg font-semibold text-white"><a href="<?php echo e(route('blog.details', $row->slug)); ?>" class="hover:underline"><?php echo e($row->title); ?></a></h3>
            
            <a href="<?php echo e(route('blog.details', $row->slug)); ?>" class="mt-3 inline-block text-sm font-semibold relative">Read More →
              <span class="absolute left-0 bottom-0 w-0 group-hover:w-full h-[1px] bg-slate-900 dark:bg-white transition-all"></span>
            </a>
          </div>
        </article>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  
      </div>
    </div>

    <!-- Sidebar -->
    <aside>
      <!-- Search -->
      
      <!-- Categories -->
      <!-- Categories (Image Cards) -->
      <div class="mb-8">
        <h4 class="font-semibold mb-3">Categories</h4>
        <ul class="space-y-3">
          <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <li>
            <a href="<?php echo e(route('blogs.category',$row->slug)); ?>"
              class="group relative block overflow-hidden rounded-lg shadow hover:shadow-lg focus:outline-none focus:ring-2 focus:ring-slate-400 dark:focus:ring-slate-600">
              <!-- Background image -->
              <div class="absolute inset-0 bg-center bg-cover transition-transform duration-500 group-hover:scale-105"
                  style="background-image:url('<?php echo e(asset('admin-assets/images/categories')); ?>/<?php echo e($row->feature_image); ?>');"></div>

              <!-- Dark gradient overlay -->
              <div class="absolute inset-0 bg-gradient-to-r from-black/60 via-black/30 to-black/10"></div>

              <!-- Content -->
              <div class="relative p-4 flex items-center justify-between">
                <div>
                  <span class="text-white font-semibold"><?php echo e($row->name); ?></span>
                  <div class="text-white/80 text-xs"><?php echo e($row->blogs_count); ?> articles</div>
                </div>
                <span class="inline-flex items-center rounded-full bg-white/90 text-slate-900 text-xs px-2 py-1 group-hover:translate-x-0.5 transition">
                  Explore
                  <svg xmlns="http://www.w3.org/2000/svg" class="ml-1 h-3.5 w-3.5" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                    <path d="M9 18l6-6-6-6" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                  </svg>
                </span>
              </div>
            </a>
          </li>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </ul>
      </div>


      <!-- Popular Posts -->
      
    </aside>
  </div>
</section>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dealqmki/blogzcenter.com/resources/views/user/pages/index.blade.php ENDPATH**/ ?>