
<?php $__env->startSection('custom-styles'); ?>
    <!-- Bootstrap Select Css -->
    <link href="<?php echo e(asset('admin-assets/css/bootstrap-select.css')); ?>" rel="stylesheet" />
    <link rel="stylesheet" href="<?php echo e(asset('admin-assets/css/summernote.css')); ?>" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card">
                <div class="header">
                    <h2><strong>Add </strong> new Blog</h2>

                </div>
                <div class="mt-2">
                    <?php echo $__env->make('admin.layouts.partials.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="body">
                    <?php if(count($errors) > 0): ?>
                        <div class="alert alert-danger">
                            <strong>Whoops!</strong> There were some problems with your input.<br><br>
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <form method="POST" action="<?php echo e(route('blogs.store')); ?>" autocomplete="off"
                        enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <label for="title">Title</label>
                        <div class="form-group">
                            <input type="text" id="title" class="form-control" placeholder="Enter Blog Title"
                                name="title" required>

                        </div>
                        <label class="form-label">Category</label>
                        <div class="form-group">
                            <select class="form-control show-tick" name="category_id" id="category">
                                <option value="">--select Category--</option>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>"><?php echo e($category); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <label class="form-label">Sub Category</label>
                        <div class="form-group">
                            <select class="form-control show-tick" name="sub_category_id" id="subcategory">
                                <option value="">--select Sub Category--</option>


                            </select>
                        </div>
                        <label for="blog_description">Blog Description</label>
                        <div class="form-group">
                            <textarea id="ckeditor"  class="" name="description"></textarea>

                        </div>
                        <label for="meta_title">Meta Title</label>
                        <div class="form-group">
                            <input type="text" id="meta_title" class="form-control" placeholder="Enter Meta Title"
                                name="meta_title" value="<?php echo e(old('meta_title')); ?>">

                        </div>
                        <label for="meta_description">Meta Description</label>
                        <div class="form-group">
                            <textarea id="meta_description" class="form-control" name="meta_description" placeholder="Entere Meta Description"></textarea>

                        </div>
                        <label class="form-label">Type</label>
                        <div class="form-group">
                            <select class="form-control show-tick" name="type">
                                <option value="">--select Type--</option>

                                <option value="featured">Featured</option>
                                <option value="latest">Latest</option>
                                <option value="popular">Most popular</option>
                            </select>
                        </div>
                        <label for="feature_image">Feature Image</label>
                        <div class="form-group">
                            <input type="file" id="feature_image" class="form-control" name="featured_image">

                        </div>

                        <label class="form-label">Status</label>
                        <div class="form-group">
                            <select class="form-control show-tick" name="status" >
                                <option value="">--select Status--</option>
                               
                                    <option value="publish">publish</option>
                                    <option value="draft">draft</option>
                            </select>
                        </div>

                        <button type="submit" class="btn btn-raised btn-primary  waves-effect">Save</button>
                        <a href="<?php echo e(route('blogs.index')); ?>" class="btn btn-default">Back</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-scripts'); ?>


<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://www.wrraptheme.com/templates/alpino/main/assets/plugins/ckeditor/ckeditor.js"></script>
<script src="<?php echo e(asset('admin-assets/js/editors.js')); ?>"></script>
    
    <script>
        $(document).on('change', '#category', function() {
            //  alert();
            var cateid = this.value;
            console.log(cateid);
            $.ajax({
                type: "GET",
                url: "<?php echo e(route('sub-category-api')); ?>",
                data: {
                    categoryid: cateid
                },
                success: function(result) {
                    var opt = '';
                    for (var i = 0; i < result.subcategory.length; i++) {
                        opt += '<option value="' + result.subcategory[i].id + '">' + result.subcategory[
                            i].name + '</option>';
                    }
                    $('#subcategory').html(opt);
                },
                error: function(error) {
                    toastr.error(error.message);
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dealqmki/brieflylive.com/resources/views/admin/pages/blogs/create.blade.php ENDPATH**/ ?>