<footer class="bg-white border-t-4 border-black mt-16 font-serif text-black max-w-7xl mx-auto px-8 py-12">

  <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12">

    <!-- Column 1: Logo + About + Social -->
    <div class="space-y-6">
      <div class="flex items-center gap-3 border-b-4 border-black pb-4">
        <img src="<?php if($settings): ?><?php echo e(asset('admin-assets/images/logos/'.$settings->footer_logo)); ?><?php endif; ?>" alt="Logo" class="h-12 object-contain" />
      </div>
      <p class="text-sm leading-relaxed tracking-tight text-justify">
        Your Central Hub for News, Trends & Smart Shopping
      </p>

      <div class="flex space-x-4 text-black">
        <!-- Social Icons -->
        <?php
        $social_links = \App\Models\SocialMedia::get();
        ?>
        <?php $__currentLoopData = $social_links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <a href="<?php echo e($social->url); ?>" target="_blank" rel="noopener noreferrer" 
           aria-label="" 
           class="text-gray-600 hover:text-gray-900 transition-colors">
              <i class="<?php echo e($social->icon); ?> h-5 w-5"></i>
        </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
    </div>

    <!-- Column 2: Categories -->
    <div>
      <h4 class="uppercase font-black tracking-tight border-b-4 border-black pb-2 mb-6 text-lg">Categories</h4>
      <ul class="space-y-4 text-sm leading-relaxed text-justify">
        <?php
          $categories = \App\Models\Category::select('id', 'slug', 'name')->limit(5)->get();
        ?>
        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <li><a href="<?php echo e(route('blogs.category',$category->slug)); ?>" class="hover:underline"><?php echo e($category->name); ?></a></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </ul>
    </div>

    <!-- Column 3: Information -->
    <div>
      <h4 class="uppercase font-black tracking-tight border-b-4 border-black pb-2 mb-6 text-lg">Information</h4>
      <ul class="space-y-4 text-sm leading-relaxed text-justify">
        <?php
          $pages = \App\Models\Page::all();
        ?>
        <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <li><a href="<?php echo e(route('page', $page->slug)); ?>" class="hover:underline"><?php echo e($page->title); ?></a></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </ul>
    </div>

    <!-- Column 4: Newsletter -->
    <div>
      <h4 class="uppercase font-black tracking-tight border-b-4 border-black pb-2 mb-6 text-lg">Newsletter</h4>
      <p class="text-sm text-justify mb-6">
        Subscribe to get the latest updates and offers.
      </p>
      <form class="flex flex-col w-full max-w-md mx-auto gap-3">
  <!-- Input -->
  <input type="email" placeholder="Your email"
         class="w-full rounded border-2 border-black px-4 py-2 text-sm font-serif focus:outline-none focus:ring-2 focus:ring-black" />

  <!-- Button -->
  <button type="submit"
          class="w-full rounded border-2 border-black bg-black text-white px-6 py-2 font-semibold uppercase tracking-wide hover:bg-gray-900 transition-colors">
    Subscribe
  </button>
</form>

    </div>

  </div>

  <!-- Bottom bar -->
  <div class="border-t-4 border-black mt-12 pt-6 text-center text-xs font-serif tracking-widest uppercase text-black">
    <p>
      &copy; <script>document.write(new Date().getFullYear())</script> 
      <?php if($settings): ?> <?php echo e($settings->site_title); ?> <?php endif; ?> — All rights reserved.
    </p>
    <p class="mt-1">Made with ❤️</p>
  </div>

</footer>
<?php /**PATH /home/dealqmki/brieflylive.com/resources/views/user/includes/footer.blade.php ENDPATH**/ ?>